/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentStorage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileContentStorage");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int myKeyBeingRemoved = -1;
    private final File myStorageRoot;
    private final TIntHashSet myFileIds = new TIntHashSet();
    private final Object myLock = new Object();
    private final SLRUCache<Integer, byte[]> myCache = new SLRUCache<Integer, byte[]>(256, 64){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public byte[] createValue(Integer key) {
            byte[] byArray;
            block7: {
                int _keyValue = key;
                if (FileContentStorage.this.myFileIds.contains(_keyValue)) {
                    byte[] byArray2;
                    File dataFile = FileContentStorage.this.getDataFile(_keyValue);
                    try {
                        byArray2 = FileUtil.loadFileBytes((File)dataFile);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                        break block7;
                    }
                    byArray = byArray2;
                    if (byArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentStorage$1.createValue must not return null");
                    return byArray;
                }
            }
            if ((byArray = EMPTY_BYTE_ARRAY) != null) return byArray;
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentStorage$1.createValue must not return null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDropFromCache(Integer key, byte[] bytes) {
            if (key == FileContentStorage.this.myKeyBeingRemoved) {
                FileUtil.delete((File)FileContentStorage.this.getDataFile(key));
            } else if (bytes.length > 0) {
                File dataFile = FileContentStorage.this.getDataFile(key);
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dataFile));
                    try {
                        os.write(bytes);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    };

    private File getDataFile(int fileId) {
        return new File(this.myStorageRoot, String.valueOf(fileId));
    }

    public FileContentStorage(File storageRoot) {
        String[] names;
        this.myStorageRoot = storageRoot;
        boolean wasCreated = storageRoot.mkdirs();
        if (!wasCreated && (names = storageRoot.list()) != null) {
            for (String name : names) {
                try {
                    this.myFileIds.add(Integer.parseInt(name));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(VirtualFile file) throws IOException {
        block6: {
            try {
                byte[] bytes = file.contentsToByteArray();
                if (bytes == null) break block6;
                Object object = this.myLock;
                synchronized (object) {
                    int fileId = Math.abs(FileBasedIndex.getFileId(file));
                    boolean added = this.myFileIds.add(fileId);
                    if (added) {
                        this.myCache.put((Object)fileId, (Object)bytes);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] remove(VirtualFile file) {
        int fileId = Math.abs(FileBasedIndex.getFileId(file));
        Object object = this.myLock;
        synchronized (object) {
            byte[] byArray;
            try {
                byte[] byArray2 = byArray = this.myFileIds.contains(fileId) ? (byte[])this.myCache.get((Object)fileId) : null;
            }
            catch (Throwable throwable) {
                if (this.myFileIds.remove(fileId)) {
                    this.myKeyBeingRemoved = fileId;
                    if (!this.myCache.remove((Object)fileId)) {
                        FileUtil.delete((File)this.getDataFile(fileId));
                    }
                    this.myKeyBeingRemoved = -1;
                }
                throw throwable;
            }
            if (this.myFileIds.remove(fileId)) {
                this.myKeyBeingRemoved = fileId;
                if (!this.myCache.remove((Object)fileId)) {
                    FileUtil.delete((File)this.getDataFile(fileId));
                }
                this.myKeyBeingRemoved = -1;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsContent(VirtualFile file) {
        int fileId = Math.abs(FileBasedIndex.getFileId(file));
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileIds.contains(fileId);
        }
    }

    public void dispose() {
        this.myCache.clear();
    }
}

