/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.Iterator;
import java.util.List;

class ChangeTrackingValueContainer<Value>
extends UpdatableValueContainer<Value> {
    private final ValueContainerImpl<Value> myAdded;
    private final ValueContainerImpl<Value> myRemoved;
    private final TIntHashSet myInvalidated;
    private final Initializer<Value> myInitializer;
    private volatile ValueContainerImpl<Value> myMerged = null;

    public ChangeTrackingValueContainer(Initializer<Value> initializer) {
        this.myInitializer = initializer;
        this.myAdded = new ValueContainerImpl();
        this.myRemoved = new ValueContainerImpl();
        this.myInvalidated = new TIntHashSet();
    }

    @Override
    public void addValue(int inputId, Value value) {
        if (this.myMerged != null) {
            this.myMerged.addValue(inputId, value);
        }
        if (!this.myRemoved.removeValue(inputId, value)) {
            this.myAdded.addValue(inputId, value);
        }
    }

    @Override
    public void removeAllValues(int inputId) {
        if (this.myMerged != null) {
            this.myMerged.removeAllValues(inputId);
        }
        this.myAdded.removeAllValues(inputId);
        this.myRemoved.removeAllValues(inputId);
        this.myInvalidated.add(inputId);
    }

    @Override
    public boolean removeValue(int inputId, Value value) {
        if (this.myMerged != null) {
            this.myMerged.removeValue(inputId, value);
        }
        if (!this.myAdded.removeValue(inputId, value) && !this.myInvalidated.contains(inputId)) {
            this.myRemoved.addValue(inputId, value);
        }
        return true;
    }

    @Override
    public int size() {
        return this.getMergedData().size();
    }

    @Override
    public Iterator<Value> getValueIterator() {
        return this.getMergedData().getValueIterator();
    }

    @Override
    public List<Value> toValueList() {
        return this.getMergedData().toValueList();
    }

    @Override
    public int[] getInputIds(Value value) {
        return this.getMergedData().getInputIds(value);
    }

    @Override
    public boolean isAssociated(Value value, int inputId) {
        return this.getMergedData().isAssociated(value, inputId);
    }

    @Override
    public ValueContainer.IntIterator getInputIdsIterator(Value value) {
        return this.getMergedData().getInputIdsIterator(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueContainer<Value> getMergedData() {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            return merged;
        }
        Object object = this.myInitializer.getLock();
        synchronized (object) {
            merged = this.myMerged;
            if (merged != null) {
                return merged;
            }
            final ValueContainerImpl newMerged = new ValueContainerImpl();
            ValueContainer fromDisk = (ValueContainer)this.myInitializer.compute();
            ValueContainer.ContainerAction addAction = new ValueContainer.ContainerAction<Value>(){

                @Override
                public void perform(int id, Value value) {
                    newMerged.addValue(id, value);
                }
            };
            ValueContainer.ContainerAction removeAction = new ValueContainer.ContainerAction<Value>(){

                @Override
                public void perform(int id, Value value) {
                    newMerged.removeValue(id, value);
                }
            };
            fromDisk.forEach(addAction);
            this.myInvalidated.forEach(new TIntProcedure(){

                public boolean execute(int inputId) {
                    newMerged.removeAllValues(inputId);
                    return true;
                }
            });
            this.myRemoved.forEach(removeAction);
            this.myAdded.forEach(addAction);
            this.setNeedsCompacting(fromDisk.needsCompacting());
            this.myMerged = newMerged;
            return newMerged;
        }
    }

    public boolean isDirty() {
        return this.myAdded.size() > 0 || this.myRemoved.size() > 0 || this.myInvalidated.size() > 0 || this.needsCompacting();
    }

    public ValueContainer<Value> getAddedDelta() {
        return this.myAdded;
    }

    public ValueContainer<Value> getRemovedDelta() {
        return this.myRemoved;
    }

    public TIntHashSet getInvalidated() {
        return this.myInvalidated;
    }

    public static interface Initializer<T>
    extends Computable<ValueContainer<T>> {
        public Object getLock();
    }
}

