/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import gnu.trove.TIntStack;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class IJSwingUtilities {
    public static void invoke(Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    public static boolean hasFocus(Component component) {
        Component focusOwner = IJSwingUtilities.findFocusOwner(component);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean hasFocus2(Component component) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        Window activeWindow = null;
        if (windowManager != null) {
            activeWindow = windowManager.getMostRecentFocusedWindow();
        }
        if (activeWindow == null) {
            return false;
        }
        Component focusedComponent = windowManager.getFocusedComponent(activeWindow);
        if (focusedComponent == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusedComponent, component);
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Iterator<Component> getParents(final Component component) {
        return new Iterator<Component>(){
            private Component myCurrent;
            {
                this.myCurrent = component;
            }

            @Override
            public boolean hasNext() {
                return this.myCurrent != null && this.myCurrent.getParent() != null;
            }

            @Override
            public Component next() {
                this.myCurrent = this.myCurrent.getParent();
                return this.myCurrent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Component> getChildren(final Container component) {
        return new Iterator<Component>(){
            private Container myCurrentParent;
            private final TIntStack myState;
            private int myCurrentIndex;
            {
                this.myCurrentParent = component;
                this.myState = new TIntStack();
                this.myCurrentIndex = 0;
            }

            @Override
            public boolean hasNext() {
                return this.hasNextChild();
            }

            @Override
            public Component next() {
                Container container;
                Component next = this.myCurrentParent.getComponent(this.myCurrentIndex);
                ++this.myCurrentIndex;
                if (next instanceof Container && (container = (Container)next).getComponentCount() > 0) {
                    this.myState.push(this.myCurrentIndex);
                    this.myCurrentIndex = 0;
                    this.myCurrentParent = container;
                }
                while (!this.hasNextChild() && this.myState.size() != 0) {
                    this.myCurrentIndex = this.myState.pop();
                    this.myCurrentParent = this.myCurrentParent.getParent();
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean hasNextChild() {
                return this.myCurrentParent.getComponentCount() > this.myCurrentIndex;
            }
        };
    }

    public static <T extends Component> T findParentOfType(Component focusOwner, Class<T> aClass) {
        return (T)((Component)ContainerUtil.find(IJSwingUtilities.getParents(focusOwner), (Condition)FilteringIterator.instanceOf(aClass)));
    }
}

