/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PackageGroupingRule
extends DirectoryGroupingRule {
    public PackageGroupingRule(Project project) {
        super(project);
    }

    protected UsageGroup getGroupForFile(VirtualFile dir) {
        PsiPackage aPackage;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(dir);
        if (psiDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            return new PackageGroup(aPackage);
        }
        return super.getGroupForFile(dir);
    }

    private class PackageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final PsiPackage myPackage;
        private Icon myOpenIcon;
        private Icon myClosedIcon;

        private PackageGroup(PsiPackage aPackage) {
            this.myPackage = aPackage;
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myOpenIcon = this.myPackage.getIcon(4);
                this.myClosedIcon = this.myPackage.getIcon(8);
            }
        }

        public Icon getIcon(boolean isOpen) {
            return isOpen ? this.myOpenIcon : this.myClosedIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myPackage.getQualifiedName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/PackageGroupingRule$PackageGroup.getText must not return null");
            }
            return string;
        }

        public FileStatus getFileStatus() {
            if (!this.isValid()) {
                return null;
            }
            PsiDirectory[] dirs = this.myPackage.getDirectories();
            return dirs.length == 1 ? FileStatusManager.getInstance((Project)PackageGroupingRule.this.myProject).getStatus(dirs[0].getVirtualFile()) : null;
        }

        public boolean isValid() {
            return this.myPackage.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            this.myPackage.navigate(focus);
        }

        public boolean canNavigate() {
            return this.myPackage.canNavigate();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageGroup)) {
                return false;
            }
            return this.myPackage.equals(((PackageGroup)o).myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.PSI_ELEMENT == key) {
                sink.put(LangDataKeys.PSI_ELEMENT, (Object)this.myPackage);
            }
        }
    }
}

