/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileColorConfiguration
implements Cloneable {
    private static final String COLOR = "color";
    private String myScopeName;
    private String myColorName;
    private static final String SCOPE_NAME = "scope";

    public FileColorConfiguration() {
    }

    public FileColorConfiguration(String scopeName, String colorName) {
        this.myScopeName = scopeName;
        this.myColorName = colorName;
    }

    public String getScopeName() {
        return this.myScopeName;
    }

    public void setScopeName(String scopeName) {
        this.myScopeName = scopeName;
    }

    public String getColorName() {
        return this.myColorName;
    }

    public void setColorName(String colorName) {
        this.myColorName = colorName;
    }

    public boolean isValid() {
        if (this.myScopeName == null || this.myScopeName.length() == 0) {
            return false;
        }
        return this.myColorName != null;
    }

    public void save(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorConfiguration.save must not be null");
        }
        if (!this.isValid()) {
            return;
        }
        Element tab = new Element("fileColor");
        tab.setAttribute(SCOPE_NAME, this.getScopeName());
        tab.setAttribute(COLOR, this.myColorName);
        e.addContent(tab);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileColorConfiguration that = (FileColorConfiguration)o;
        if (!this.myColorName.equals(that.myColorName)) {
            return false;
        }
        return this.myScopeName.equals(that.myScopeName);
    }

    public int hashCode() {
        int result = this.myScopeName.hashCode();
        result = 31 * result + this.myColorName.hashCode();
        return result;
    }

    public FileColorConfiguration clone() throws CloneNotSupportedException {
        FileColorConfiguration result = new FileColorConfiguration();
        result.myColorName = this.myColorName;
        result.myScopeName = this.myScopeName;
        return result;
    }

    @Nullable
    public static FileColorConfiguration load(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorConfiguration.load must not be null");
        }
        String path = e.getAttributeValue(SCOPE_NAME);
        if (path == null) {
            return null;
        }
        String colorName = e.getAttributeValue(COLOR);
        if (colorName == null) {
            return null;
        }
        return new FileColorConfiguration(path, colorName);
    }
}

