/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.JBAwtEventQueue;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.MoveComponentListener;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ResizeComponentListener;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupComponent;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ImageLoader;
import com.intellij.util.Processor;
import com.intellij.util.ui.ChildFocusWatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractPopup
implements JBPopup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.AbstractPopup");
    private static final Image ourMacCorner = ImageLoader.loadFromResource((String)"/general/macCorner.png");
    private PopupComponent myPopup;
    private MyContentPanel myContent;
    private JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private boolean myFocusable;
    private boolean myForcedHeavyweight = false;
    private boolean myLocateWithinScreen = true;
    private boolean myResizable = false;
    private JPanel myHeaderPanel;
    private CaptionPanel myCaption = null;
    private JComponent myComponent;
    private String myDimensionServiceKey = null;
    private Computable<Boolean> myCallBack = null;
    private Project myProject;
    private boolean myCancelOnClickOutside;
    private Set<JBPopupListener> myListeners;
    private boolean myUseDimServiceForXYLocation;
    private MouseChecker myCancelOnMouseOutCallback;
    private Canceller myMouseOutCanceller;
    private boolean myCancelOnWindow;
    private Dimension myForcedSize;
    private Point myForcedLocation;
    private ChildFocusWatcher myFocusWatcher;
    private boolean myCancelKeyEnabled;
    private boolean myLocateByContent;
    protected FocusTrackback myFocusTrackback;
    private Dimension myMinSize;
    private ArrayList<Object> myUserData;
    private boolean myShadowed;
    private float myAlpha = 0.0f;
    private float myLastAlpha = 0.0f;
    private MaskProvider myMaskProvider;
    private Window myWindow;
    private boolean myInStack;
    private MyWindowListener myWindowListener;
    private boolean myModalContext;
    private Component[] myFocusOwners;
    private PopupBorder myPopupBorder;
    private Dimension myRestoreWindowSize;
    protected Component myOwner;
    protected Component myRequestorComponent;
    private boolean myHeaderAlwaysFocusable;
    private boolean myMovable;
    private JComponent myHeaderComponent;
    protected InputEvent myDisposeEvent;
    private Runnable myFinalRunnable;
    protected final SpeedSearch mySpeedSearch = new SpeedSearch(){
        boolean searchFieldShown = false;

        protected void update() {
            AbstractPopup.this.mySpeedSearchPatternField.setBackground(new JTextField().getBackground());
            AbstractPopup.this.onSpeedSearchPatternChanged();
            AbstractPopup.this.mySpeedSearchPatternField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                AbstractPopup.this.setHeaderComponent(AbstractPopup.this.mySpeedSearchPatternField);
                this.searchFieldShown = true;
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                AbstractPopup.this.setHeaderComponent(null);
                this.searchFieldShown = false;
            }
        }

        public void noHits() {
            AbstractPopup.this.mySpeedSearchPatternField.setBackground(LightColors.RED);
        }
    };
    private JTextField mySpeedSearchPatternField;
    private boolean myNativePopup;
    private boolean myMayBeParent;

    AbstractPopup() {
    }

    AbstractPopup init(Project project, @NotNull JComponent component, @Nullable JComponent preferredFocusedComponent, boolean requestFocus, boolean focusable, boolean forceHeavyweight, boolean movable, String dimensionServiceKey, boolean resizable, @Nullable String caption, @Nullable Computable<Boolean> callback, boolean cancelOnClickOutside, @Nullable Set<JBPopupListener> listeners, boolean useDimServiceForXYLocation, InplaceButton commandButton, @Nullable IconButton cancelButton, @Nullable MouseChecker cancelOnMouseOutCallback, boolean cancelOnWindow, @Nullable ActiveIcon titleIcon, boolean cancelKeyEnabled, boolean locateBycontent, boolean placeWithinScreenBounds, @Nullable Dimension minSize, float alpha, @Nullable MaskProvider maskProvider, boolean inStack, boolean modalContext, @Nullable Component[] focusOwners, @Nullable String adText, boolean headerAlwaysFocusable, @NotNull List<Pair<ActionListener, KeyStroke>> keyboardActions, Component settingsButtons, final @Nullable Processor<JBPopup> pinCallback, boolean mayBeParent) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.init must not be null");
        }
        if (keyboardActions == null) {
            throw new IllegalArgumentException("Argument 30 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.init must not be null");
        }
        if (requestFocus && !focusable) assert (false) : "Incorrect argument combination: requestFocus=" + requestFocus + " focusable=" + focusable;
        this.myProject = project;
        this.myComponent = component;
        this.myPopupBorder = PopupBorder.Factory.create((boolean)true);
        this.myShadowed = !movable && !resizable && Registry.is((String)"ide.popup.dropShadow");
        this.myContent = this.createContentPanel(resizable, this.myPopupBorder, AbstractPopup.isToDrawMacCorner());
        this.myMayBeParent = mayBeParent;
        this.myContent.add((Component)component, "Center");
        if (adText != null) {
            this.myContent.add((Component)HintUtil.createAdComponent(adText), "South");
        }
        this.myCancelKeyEnabled = cancelKeyEnabled;
        this.myLocateByContent = locateBycontent;
        this.myLocateWithinScreen = placeWithinScreenBounds;
        this.myAlpha = alpha;
        this.myMaskProvider = maskProvider;
        this.myInStack = inStack;
        this.myModalContext = modalContext;
        this.myFocusOwners = focusOwners;
        this.myHeaderAlwaysFocusable = headerAlwaysFocusable;
        this.myMovable = movable;
        ActiveIcon actualIcon = titleIcon == null ? new ActiveIcon((Icon)new EmptyIcon(0)) : titleIcon;
        this.myHeaderPanel = new JPanel(new BorderLayout());
        if (caption != null) {
            if (caption.length() > 0) {
                this.myCaption = new TitlePanel(actualIcon.getRegular(), actualIcon.getInactive());
                ((TitlePanel)this.myCaption).setText(caption);
            } else {
                this.myCaption = new CaptionPanel();
            }
            if (pinCallback != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(new IconButton("Pin", IconLoader.getIcon((String)"/general/autohideOff.png"), IconLoader.getIcon((String)"/general/autohideOff.png"), IconLoader.getIcon((String)"/general/autohideOffInactive.png")), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pinCallback.process((Object)AbstractPopup.this);
                    }
                }));
            } else if (cancelButton != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(cancelButton, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractPopup.this.cancel();
                    }
                }));
            } else if (commandButton != null) {
                this.myCaption.setButtonComponent((ActiveComponent)commandButton);
            }
        } else {
            this.myCaption = new CaptionPanel();
            this.myCaption.setBorder(null);
            this.myCaption.setPreferredSize(new Dimension(0, 0));
        }
        this.setWindowActive(this.myHeaderAlwaysFocusable);
        this.myHeaderPanel.add((Component)this.myCaption, "North");
        this.myContent.add((Component)this.myHeaderPanel, "North");
        this.myForcedHeavyweight = forceHeavyweight;
        this.myResizable = resizable;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
        this.myRequestFocus = requestFocus;
        this.myFocusable = focusable;
        this.myDimensionServiceKey = dimensionServiceKey;
        this.myCallBack = callback;
        this.myCancelOnClickOutside = cancelOnClickOutside;
        this.myCancelOnMouseOutCallback = cancelOnMouseOutCallback;
        this.myListeners = listeners == null ? new HashSet() : listeners;
        this.myUseDimServiceForXYLocation = useDimServiceForXYLocation;
        this.myCancelOnWindow = cancelOnWindow;
        this.myMinSize = minSize;
        for (Pair<ActionListener, KeyStroke> pair : keyboardActions) {
            this.myContent.registerKeyboardAction((ActionListener)pair.getFirst(), (KeyStroke)pair.getSecond(), 2);
        }
        if (settingsButtons != null) {
            this.myCaption.addSettingsComponent(settingsButtons);
        }
        return this;
    }

    private void setWindowActive(boolean active) {
        boolean value;
        boolean bl = value = this.myHeaderAlwaysFocusable || active;
        if (this.myCaption != null) {
            this.myCaption.setActive(value);
        }
        this.myPopupBorder.setActive(value);
        this.myContent.repaint();
    }

    @NotNull
    protected MyContentPanel createContentPanel(boolean resizable, PopupBorder border, boolean isToDrawMacCorner) {
        MyContentPanel myContentPanel = new MyContentPanel(resizable, border, isToDrawMacCorner, this.myShadowed);
        if (myContentPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/AbstractPopup.createContentPanel must not return null");
        }
        return myContentPanel;
    }

    public static boolean isToDrawMacCorner() {
        return SystemInfo.isMac;
    }

    public String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public void setDimensionServiceKey(String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public void showInCenterOf(@NotNull Component aContainer) {
        if (aContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showInCenterOf must not be null");
        }
        Point popupPoint = AbstractPopup.getCenterOf(aContainer, this.myContent);
        this.show(aContainer, popupPoint.x, popupPoint.y, false);
    }

    public void setAdText(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.setAdText must not be null");
        }
        this.myContent.add((Component)HintUtil.createAdComponent(s, BorderFactory.createEmptyBorder(3, 5, 3, 5)), "South");
    }

    public static Point getCenterOf(Component aContainer, JComponent content) {
        JComponent component = AbstractPopup.getTargetComponent(aContainer);
        Point containerScreenPoint = component.getVisibleRect().getLocation();
        SwingUtilities.convertPointToScreen(containerScreenPoint, aContainer);
        return UIUtil.getCenterPoint((Rectangle)new Rectangle(containerScreenPoint, component.getVisibleRect().getSize()), (Dimension)content.getPreferredSize());
    }

    public void showCenteredInCurrentWindow(@NotNull Project project) {
        Component parent;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showCenteredInCurrentWindow must not be null");
        }
        Window window = null;
        Component focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(project);
        if (focusedComponent != null && (parent = UIUtil.findUltimateParent((Component)focusedComponent)) instanceof Window) {
            window = (Window)parent;
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        if (window != null) {
            this.showInCenterOf(window);
        }
    }

    public void showUnderneathOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showUnderneathOf must not be null");
        }
        this.show(new RelativePoint(aComponent, new Point(0, aComponent.getHeight())));
    }

    public void show(@NotNull RelativePoint aPoint) {
        if (aPoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.show must not be null");
        }
        Point screenPoint = aPoint.getScreenPoint();
        this.show(aPoint.getComponent(), screenPoint.x, screenPoint.y, false);
    }

    public void showInScreenCoordinates(@NotNull Component owner, @NotNull Point point) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showInScreenCoordinates must not be null");
        }
        if (point == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showInScreenCoordinates must not be null");
        }
        this.show(owner, point.x, point.y, false);
    }

    public void showInBestPositionFor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showInBestPositionFor must not be null");
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            this.showInBestPositionFor(editor);
        } else {
            this.show(this.relativePointByQuickSearch(dataContext));
        }
    }

    public void showInFocusCenter() {
        Component focused = AbstractPopup.getWndManager().getFocusedComponent(this.myProject);
        if (focused != null) {
            this.showInCenterOf(focused);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(this.myProject);
            this.showInCenterOf(frame.getRootPane());
        }
    }

    private RelativePoint relativePointByQuickSearch(DataContext dataContext) {
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        if (dominantArea != null) {
            JLayeredPane layeredPane;
            Component focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(this.myProject);
            Window window = SwingUtilities.windowForComponent(focusedComponent);
            if (window instanceof JFrame) {
                layeredPane = ((JFrame)window).getLayeredPane();
            } else if (window instanceof JDialog) {
                layeredPane = ((JDialog)window).getLayeredPane();
            } else if (window instanceof JWindow) {
                layeredPane = ((JWindow)window).getLayeredPane();
            } else {
                throw new IllegalStateException("cannot find parent window: project=" + this.myProject + "; window=" + window);
            }
            return this.relativePointWithDominantRectangle(layeredPane, dominantArea);
        }
        return JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
    }

    public void showInBestPositionFor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.showInBestPositionFor must not be null");
        }
        assert (editor.getComponent().isShowing()) : "Editor must be showing on the screen";
        DataContext context = ((EditorEx)editor).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(context);
        if (dominantArea != null && !this.myRequestFocus) {
            JLayeredPane layeredPane = editor.getContentComponent().getRootPane().getLayeredPane();
            this.show(this.relativePointWithDominantRectangle(layeredPane, dominantArea));
        } else {
            this.show(JBPopupFactory.getInstance().guessBestPopupLocation(editor));
        }
    }

    public void addPopupListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    private RelativePoint relativePointWithDominantRectangle(JLayeredPane layeredPane, Rectangle bounds) {
        RelativePoint relativePoint;
        Dimension dimension;
        Dimension preferredSize = this.getComponent().getPreferredSize();
        if (this.myDimensionServiceKey != null && (dimension = DimensionService.getInstance().getSize(this.myDimensionServiceKey, this.myProject)) != null) {
            preferredSize = dimension;
        }
        Point leftTopCorner = new Point(bounds.x + bounds.width, bounds.y);
        Point leftTopCornerScreen = (Point)leftTopCorner.clone();
        SwingUtilities.convertPointToScreen(leftTopCornerScreen, layeredPane);
        if (!ScreenUtil.isOutsideOnTheRightOFScreen((Rectangle)new Rectangle(leftTopCornerScreen.x, leftTopCornerScreen.y, preferredSize.width, preferredSize.height))) {
            relativePoint = new RelativePoint((Component)layeredPane, leftTopCorner);
        } else if (bounds.x > preferredSize.width) {
            relativePoint = new RelativePoint((Component)layeredPane, new Point(bounds.x - preferredSize.width, bounds.y));
        } else {
            this.setDimensionServiceKey(null);
            Rectangle screen = ScreenUtil.getScreenRectangle((int)leftTopCornerScreen.x, (int)leftTopCornerScreen.y);
            int spaceOnTheLeft = bounds.x;
            int spaceOnTheRight = screen.x + screen.width - leftTopCornerScreen.x;
            if (spaceOnTheLeft > spaceOnTheRight) {
                relativePoint = new RelativePoint((Component)layeredPane, new Point(0, bounds.y));
                this.myComponent.setPreferredSize(new Dimension(spaceOnTheLeft, Math.max(preferredSize.height, 200)));
            } else {
                relativePoint = new RelativePoint((Component)layeredPane, leftTopCorner);
                this.myComponent.setPreferredSize(new Dimension(spaceOnTheRight, Math.max(preferredSize.height, 200)));
            }
        }
        return relativePoint;
    }

    public final void cancel() {
        this.cancel(null);
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public void cancel(InputEvent e) {
        if (this.isDisposed()) {
            return;
        }
        if (this.myPopup != null) {
            Container popupWindow;
            JRootPane root;
            if (!this.canClose()) {
                return;
            }
            this.storeDimensionSize(this.myContent.getSize());
            if (this.myUseDimServiceForXYLocation && (root = this.myComponent.getRootPane()) != null && (popupWindow = root.getParent()) != null && popupWindow.isShowing()) {
                this.storeLocation(popupWindow.getLocationOnScreen());
            }
            if (e instanceof MouseEvent) {
                JBAwtEventQueue.getInstance().blockNextEvents((MouseEvent)e);
            }
            this.myPopup.hide(false);
            if (ApplicationManagerEx.getApplicationEx() != null) {
                StackingPopupDispatcher.getInstance().onPopupHidden((JBPopup)this);
            }
            if (this.myInStack) {
                this.myFocusTrackback.restoreFocus();
            }
            this.disposePopup();
            if (this.myListeners != null) {
                for (JBPopupListener each : this.myListeners) {
                    each.onClosed(new LightweightWindowEvent((LightweightWindow)this));
                }
            }
        }
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    private void disposePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide(true);
        }
        this.myPopup = null;
    }

    public boolean canClose() {
        return this.myCallBack == null || (Boolean)this.myCallBack.compute() != false;
    }

    public boolean isVisible() {
        return this.myPopup != null;
    }

    public void show(Component owner) {
        this.show(owner, -1, -1, true);
    }

    public void show(Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        Insets insets;
        Point storedLocation;
        if (ApplicationManagerEx.getApplicationEx() != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Popup was already disposed. Recreate a new instance to show again");
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        boolean shouldShow = this.beforeShow();
        if (!shouldShow) {
            return;
        }
        this.prepareToShow();
        if (this.myInStack) {
            this.myFocusTrackback = new FocusTrackback((Object)this, owner, true);
            this.myFocusTrackback.setMustBeShown(true);
        }
        Dimension sizeToSet = null;
        if (this.myDimensionServiceKey != null) {
            sizeToSet = DimensionService.getInstance().getSize(this.myDimensionServiceKey, this.myProject);
        }
        if (this.myForcedSize != null) {
            sizeToSet = this.myForcedSize;
        }
        if (this.myMinSize == null) {
            this.myMinSize = this.myContent.getMinimumSize();
        }
        if (sizeToSet == null) {
            sizeToSet = this.myContent.getPreferredSize();
        }
        if (sizeToSet != null) {
            sizeToSet.width = Math.max(sizeToSet.width, this.myMinSize.width);
            sizeToSet.height = Math.max(sizeToSet.height, this.myMinSize.height);
            this.myContent.setSize(sizeToSet);
            this.myContent.setPreferredSize(sizeToSet);
        }
        Point xy = new Point(aScreenX, aScreenY);
        boolean adjustXY = true;
        if (this.myDimensionServiceKey != null && (storedLocation = DimensionService.getInstance().getLocation(this.myDimensionServiceKey, this.myProject)) != null) {
            xy = storedLocation;
            adjustXY = false;
        }
        if (adjustXY && (insets = this.myContent.getInsets()) != null) {
            xy.x -= insets.left;
            xy.y -= insets.top;
        }
        if (considerForcedXY && this.myForcedLocation != null) {
            xy = this.myForcedLocation;
        }
        if (this.myLocateByContent) {
            Dimension captionSize = this.myHeaderPanel.getPreferredSize();
            xy.y -= captionSize.height;
        }
        Rectangle targetBounds = new Rectangle(xy, this.myContent.getPreferredSize());
        Rectangle original = new Rectangle(targetBounds);
        if (this.myLocateWithinScreen) {
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)targetBounds);
        }
        if (this.myMouseOutCanceller != null) {
            this.myMouseOutCanceller.myEverEntered = targetBounds.equals(original);
        }
        this.myOwner = IdeFrameImpl.findNearestModalComponent(owner);
        if (this.myOwner == null) {
            this.myOwner = owner;
        }
        this.myRequestorComponent = owner;
        PopupComponent.Factory factory = this.getFactory(this.myForcedHeavyweight || this.myResizable);
        this.myNativePopup = factory.isNativePopup();
        this.myPopup = factory.getPopup(this.myOwner, this.myContent, targetBounds.x, targetBounds.y);
        if (this.myResizable) {
            JRootPane root = this.myContent.getRootPane();
            IdeGlassPaneImpl glass = new IdeGlassPaneImpl(root);
            root.setGlassPane(glass);
            ResizeComponentListener resizeListener = new ResizeComponentListener(this);
            glass.addMousePreprocessor(resizeListener, (Disposable)this);
            glass.addMouseMotionPreprocessor(resizeListener, (Disposable)this);
        }
        if (this.myCaption != null && this.myMovable) {
            final MoveComponentListener moveListener = new MoveComponentListener(this.myCaption){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.isConsumed()) {
                        return;
                    }
                    if (UIUtil.isCloseClick((MouseEvent)e) && AbstractPopup.this.myCaption.isWithinPanel(e)) {
                        AbstractPopup.this.cancel();
                    }
                }
            };
            ListenerUtil.addMouseListener((Component)this.myCaption, moveListener);
            ListenerUtil.addMouseMotionListener((Component)this.myCaption, moveListener);
            final MyContentPanel saved = this.myContent;
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    ListenerUtil.removeMouseListener(saved, moveListener);
                    ListenerUtil.removeMouseMotionListener(saved, moveListener);
                }
            });
        }
        for (JBPopupListener listener : this.myListeners) {
            listener.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        this.myPopup.show();
        Window window = SwingUtilities.getWindowAncestor(this.myContent);
        this.myWindowListener = new MyWindowListener();
        window.addWindowListener(this.myWindowListener);
        if (this.myFocusable) {
            window.setFocusableWindowState(true);
            window.setFocusable(true);
            if (this.myRequestFocus) {
                window.requestFocusInWindow();
            }
        }
        this.myWindow = this.updateMaskAndAlpha(window);
        if (this.myWindow instanceof JWindow) {
            ((JWindow)this.myWindow).getRootPane().putClientProperty("JBPopup", this);
        }
        if (this.myWindow != null && !this.myMayBeParent && !(this.myWindow instanceof Frame)) {
            WindowManager.getInstance().doNotSuggestAsParent(this.myWindow);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractPopup.this.isDisposed()) {
                    return;
                }
                if (AbstractPopup.this.myRequestFocus) {
                    AbstractPopup.this.requestFocus();
                }
                if (AbstractPopup.this.myPreferredFocusedComponent != null && AbstractPopup.this.myInStack) {
                    AbstractPopup.this.myFocusTrackback.registerFocusComponent(AbstractPopup.this.myPreferredFocusedComponent);
                }
                AbstractPopup.this.afterShow();
            }
        });
    }

    private void prepareToShow() {
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = (Point)e.getPoint().clone();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                Dimension dimension = AbstractPopup.this.myContent.getSize();
                dimension.height = dimension.height + (AbstractPopup.this.myResizable && AbstractPopup.isToDrawMacCorner() ? ourMacCorner.getHeight(AbstractPopup.this.myContent) : 4);
                dimension.width += 4;
                Point locationOnScreen = AbstractPopup.this.myContent.getLocationOnScreen();
                Rectangle bounds = new Rectangle(new Point(locationOnScreen.x - 2, locationOnScreen.y - 2), dimension);
                if (!bounds.contains(point)) {
                    AbstractPopup.this.cancel();
                }
            }
        };
        this.myContent.addMouseListener(mouseAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                AbstractPopup.this.myContent.removeMouseListener(mouseAdapter);
            }
        });
        this.myContent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractPopup.this.myCancelKeyEnabled) {
                    AbstractPopup.this.cancel();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.myContent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbstractPopup.this.mySpeedSearch.process(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractPopup.this.mySpeedSearch.process(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AbstractPopup.this.mySpeedSearch.process(e);
            }
        });
        if (this.myCancelOnMouseOutCallback != null || this.myCancelOnWindow) {
            this.myMouseOutCanceller = new Canceller();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myMouseOutCanceller, 253L);
        }
        this.myFocusWatcher = new ChildFocusWatcher(this.myContent){

            @Override
            protected void onFocusGained(FocusEvent event) {
                AbstractPopup.this.setWindowActive(true);
            }

            @Override
            protected void onFocusLost(FocusEvent event) {
                AbstractPopup.this.setWindowActive(false);
            }
        };
        this.mySpeedSearchPatternField = new JTextField();
        if (SystemInfo.isMac) {
            Font f = this.mySpeedSearchPatternField.getFont();
            this.mySpeedSearchPatternField.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        }
    }

    private Window updateMaskAndAlpha(Window window) {
        if (window == null) {
            return window;
        }
        WindowManagerEx wndManager = AbstractPopup.getWndManager();
        if (wndManager == null) {
            return window;
        }
        if (!wndManager.isAlphaModeEnabled(window)) {
            return window;
        }
        if (this.myAlpha != this.myLastAlpha) {
            wndManager.setAlphaModeRatio(window, this.myAlpha);
            this.myLastAlpha = this.myAlpha;
        }
        if (this.myMaskProvider != null) {
            Dimension size = window.getSize();
            Shape mask = this.myMaskProvider.getMask(size);
            wndManager.setWindowMask(window, mask);
        }
        return window;
    }

    private static WindowManagerEx getWndManager() {
        return ApplicationManagerEx.getApplicationEx() != null ? WindowManagerEx.getInstanceEx() : null;
    }

    public boolean isDisposed() {
        return this.myContent == null;
    }

    protected boolean beforeShow() {
        if (ApplicationManagerEx.getApplicationEx() == null) {
            return true;
        }
        StackingPopupDispatcher.getInstance().onPopupShown((JBPopup)this, this.myInStack);
        return true;
    }

    protected void afterShow() {
    }

    protected final void requestFocus() {
        if (!this.myFocusable) {
            return;
        }
        if (this.myPreferredFocusedComponent != null) {
            if (this.myProject != null) {
                this.getFocusManager().requestFocus((Component)this.myPreferredFocusedComponent, true);
            } else {
                this.myPreferredFocusedComponent.requestFocus();
            }
        }
    }

    private IdeFocusManager getFocusManager() {
        if (this.myProject != null) {
            return IdeFocusManager.getInstance((Project)this.myProject);
        }
        if (this.myOwner != null) {
            return IdeFocusManager.findInstanceByComponent((Component)this.myOwner);
        }
        return IdeFocusManager.findInstance();
    }

    private static JComponent getTargetComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return (JComponent)aComponent;
        }
        if (aComponent instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)aComponent)).getRootPane();
        }
        LOG.error("Cannot find target for:" + aComponent);
        return null;
    }

    private PopupComponent.Factory getFactory(boolean forceHeavyweight) {
        if (this.isPersistent()) {
            return new PopupComponent.Factory.Dialog();
        }
        if (forceHeavyweight || !SystemInfo.isWindows) {
            return new PopupComponent.Factory.AwtHeavyweight();
        }
        return new PopupComponent.Factory.AwtDefault();
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public void setLocation(RelativePoint p) {
        AbstractPopup.setLocation(p, this.myPopup, this.myContent);
    }

    private static void setLocation(RelativePoint p, PopupComponent popup, Component content) {
        if (popup == null) {
            return;
        }
        Window wnd = popup.getWindow();
        assert (wnd != null);
        wnd.setLocation(p.getScreenPoint());
    }

    public void pack() {
        Window window = SwingUtilities.getWindowAncestor(this.myContent);
        window.pack();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        Toolkit toolkit;
        Disposer.dispose((Disposable)this, (boolean)false);
        assert (ApplicationManager.getApplication().isDispatchThread());
        if (this.myPopup != null) {
            this.cancel(this.myDisposeEvent);
        }
        if (this.myContent != null) {
            this.myContent.removeAll();
        }
        this.myContent = null;
        this.myComponent = null;
        this.myFocusTrackback = null;
        this.myCallBack = null;
        this.myListeners = null;
        if (this.myMouseOutCanceller != null && (toolkit = Toolkit.getDefaultToolkit()) != null) {
            toolkit.removeAWTEventListener(this.myMouseOutCanceller);
        }
        this.myMouseOutCanceller = null;
        if (this.myFocusWatcher != null) {
            this.myFocusWatcher.dispose();
            this.myFocusWatcher = null;
        }
        this.resetWindow();
        if (this.myFinalRunnable != null) {
            this.getFocusManager().doWhenFocusSettlesDown(this.myFinalRunnable);
            this.myFinalRunnable = null;
        }
    }

    private void resetWindow() {
        if (this.myWindow != null && AbstractPopup.getWndManager() != null) {
            AbstractPopup.getWndManager().resetWindow(this.myWindow);
            if (this.myWindowListener != null) {
                this.myWindow.removeWindowListener(this.myWindowListener);
            }
            if (this.myWindow instanceof JWindow) {
                ((JWindow)this.myWindow).getRootPane().putClientProperty("JBPopup", null);
            }
            this.myWindow = null;
            this.myWindowListener = null;
        }
    }

    public void storeDimensionSize(Dimension size) {
        if (this.myDimensionServiceKey != null) {
            DimensionService.getInstance().setSize(this.myDimensionServiceKey, size, this.myProject);
        }
    }

    public void storeLocation(Point xy) {
        if (this.myDimensionServiceKey != null) {
            DimensionService.getInstance().setLocation(this.myDimensionServiceKey, xy, this.myProject);
        }
    }

    public boolean isCancelOnClickOutside() {
        return this.myCancelOnClickOutside;
    }

    public void setLocation(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.setLocation must not be null");
        }
        if (this.myPopup == null) {
            this.myForcedLocation = screenPoint;
        } else {
            AbstractPopup.moveTo(this.myContent, screenPoint, this.myLocateByContent ? this.myHeaderPanel.getPreferredSize() : null);
        }
    }

    public static Window moveTo(JComponent content, Point screenPoint, Dimension headerCorrectionSize) {
        AbstractPopup.setDefaultCursor(content);
        Window wnd = SwingUtilities.getWindowAncestor(content);
        if (headerCorrectionSize != null) {
            screenPoint.y -= headerCorrectionSize.height;
        }
        wnd.setLocation(screenPoint);
        return wnd;
    }

    public void setSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/AbstractPopup.setSize must not be null");
        }
        if (this.myPopup == null) {
            this.myForcedSize = size;
        } else {
            this.updateMaskAndAlpha(AbstractPopup.setSize(this.myContent, size));
        }
    }

    public static Window setSize(JComponent content, Dimension size) {
        Window popupWindow = SwingUtilities.windowForComponent(content);
        Point location = popupWindow.getLocation();
        popupWindow.setBounds(location.x, location.y, size.width, size.height);
        return popupWindow;
    }

    public static void setDefaultCursor(JComponent content) {
        Window wnd = SwingUtilities.getWindowAncestor(content);
        if (wnd != null) {
            wnd.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setCaption(String title) {
        if (this.myCaption instanceof TitlePanel) {
            ((TitlePanel)this.myCaption).setText(title);
        }
    }

    public boolean isPersistent() {
        return !this.myCancelOnClickOutside && !this.myCancelOnWindow;
    }

    public boolean isNativePopup() {
        return this.myNativePopup;
    }

    public void setUiVisible(boolean visible) {
        if (this.myPopup != null) {
            if (visible) {
                this.myPopup.show();
                Window window = this.getPopupWindow();
                if (window != null && this.myRestoreWindowSize != null) {
                    window.setSize(this.myRestoreWindowSize);
                    this.myRestoreWindowSize = null;
                }
            } else {
                Window window = this.getPopupWindow();
                if (window != null) {
                    this.myRestoreWindowSize = window.getSize();
                    window.setVisible(true);
                }
            }
        }
    }

    private Window getPopupWindow() {
        return this.myPopup.getWindow();
    }

    public void setUserData(ArrayList<Object> userData) {
        this.myUserData = userData;
    }

    public <T> T getUserData(Class<T> userDataClass) {
        if (this.myUserData != null) {
            for (Object o : this.myUserData) {
                if (!userDataClass.isInstance(o)) continue;
                return (T)o;
            }
        }
        return null;
    }

    public boolean isModalContext() {
        return this.myModalContext;
    }

    public boolean isFocused() {
        if (this.myComponent != null && AbstractPopup.isFocused(new Component[]{SwingUtilities.getWindowAncestor(this.myComponent)})) {
            return true;
        }
        return AbstractPopup.isFocused(this.myFocusOwners);
    }

    public static boolean isFocused(@Nullable Component[] components) {
        if (components == null) {
            return false;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        for (Component each : components) {
            if (each == null || !SwingUtilities.isDescendingFrom(owner, each)) continue;
            return true;
        }
        return false;
    }

    public boolean isCancelKeyEnabled() {
        return this.myCancelKeyEnabled;
    }

    @NotNull
    CaptionPanel getTitle() {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/AbstractPopup.getTitle must not return null");
        }
        return captionPanel;
    }

    private void setHeaderComponent(JComponent c) {
        boolean doRevalidate = false;
        if (this.myHeaderComponent != null) {
            this.myHeaderPanel.remove(this.myHeaderComponent);
            this.myHeaderPanel.add((Component)this.myCaption, "North");
            this.myHeaderComponent = null;
            doRevalidate = true;
        }
        if (c != null) {
            this.myHeaderPanel.remove((Component)this.myCaption);
            this.myHeaderPanel.add((Component)c, "North");
            this.myHeaderComponent = c;
            Dimension size = this.myContent.getSize();
            if (size.height < c.getPreferredSize().height * 2) {
                size.height += c.getPreferredSize().height;
                this.setSize(size);
            }
            doRevalidate = true;
        }
        if (doRevalidate) {
            this.myContent.revalidate();
        }
    }

    public void addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(JBPopupListener listener) {
        this.myListeners.remove(listener);
    }

    protected void onSpeedSearchPatternChanged() {
    }

    public Component getOwner() {
        return this.myRequestorComponent;
    }

    public void setMinimumSize(Dimension size) {
        this.myMinSize = size;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public void setFinalRunnable(Runnable finalRunnable) {
        this.myFinalRunnable = finalRunnable;
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            AbstractPopup.this.resetWindow();
        }
    }

    private class Canceller
    implements AWTEventListener {
        private boolean myEverEntered = false;

        private Canceller() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 205) {
                if (AbstractPopup.this.myCancelOnWindow) {
                    AbstractPopup.this.cancel();
                }
            } else if (event.getID() == 504) {
                if (this.withinPopup(event)) {
                    this.myEverEntered = true;
                }
            } else if (event.getID() == 503 && AbstractPopup.this.myCancelOnMouseOutCallback != null && this.myEverEntered && !this.withinPopup(event) && AbstractPopup.this.myCancelOnMouseOutCallback.check((MouseEvent)event)) {
                AbstractPopup.this.cancel();
            }
        }

        private boolean withinPopup(AWTEvent event) {
            if (!AbstractPopup.this.myContent.isShowing()) {
                return false;
            }
            MouseEvent mouse = (MouseEvent)event;
            Point point = mouse.getPoint();
            SwingUtilities.convertPointToScreen(point, mouse.getComponent());
            return new Rectangle(AbstractPopup.this.myContent.getLocationOnScreen(), AbstractPopup.this.myContent.getSize()).contains(point);
        }
    }

    public static class MyContentPanel
    extends JPanel {
        private final boolean myResizable;
        private final boolean myDrawMacCorner;
        private final boolean myShadowed;

        public MyContentPanel(boolean resizable, PopupBorder border, boolean drawMacCorner) {
            this(resizable, border, drawMacCorner, false);
        }

        public MyContentPanel(boolean resizable, final PopupBorder border, boolean drawMacCorner, boolean shadowed) {
            super(new BorderLayout());
            this.myResizable = resizable;
            this.myDrawMacCorner = drawMacCorner;
            this.myShadowed = shadowed;
            if (this.isShadowPossible()) {
                this.setOpaque(false);
                this.setBorder(new EmptyBorder(4, 7, 10, 7){

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                        border.paintBorder(c, g, x + 7 - 1, y + 4 - 1, width - 14 + 2, height - 4 - 10 + 2);
                    }
                });
            } else {
                this.setBorder((Border)border);
            }
        }

        private boolean isShadowPossible() {
            return this.myShadowed && !SystemInfo.isMac && !UISettings.isRemoteDesktopConnected();
        }

        @Override
        public void paint(Graphics g) {
            if (this.isShadowPossible()) {
                this.paintShadow(g);
            }
            super.paint(g);
            if (this.myResizable && this.myDrawMacCorner) {
                g.drawImage(ourMacCorner, this.getX() + this.getWidth() - ourMacCorner.getWidth(this), this.getY() + this.getHeight() - ourMacCorner.getHeight(this), this);
            }
        }

        private void paintShadow(Graphics g) {
            BufferedImage capture = null;
            try {
                Point onScreen = this.getLocationOnScreen();
                capture = new Robot().createScreenCapture(new Rectangle(onScreen.x, onScreen.y, this.getWidth() + 14, this.getHeight() + 4 + 10));
                BufferedImage shadow = ShadowBorderPainter.createPopupShadow(this, this.getWidth(), this.getHeight());
                ((Graphics2D)capture.getGraphics()).drawImage(shadow, null, null);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (capture != null) {
                g.drawImage(capture, 0, 0, null);
            }
        }
    }
}

