/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeSpeedSearch
extends SpeedSearchBase<JTree> {
    private boolean myCanExpand;
    private static final Convertor<TreePath, String> TO_STRING = new Convertor<TreePath, String>(){

        public String convert(TreePath object) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
            return node.toString();
        }
    };
    private final Convertor<TreePath, String> myToStringConvertor;
    public static final Convertor<TreePath, String> NODE_DESCRIPTOR_TOSTRING = new Convertor<TreePath, String>(){

        public String convert(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject instanceof NodeDescriptor) {
                NodeDescriptor descr = (NodeDescriptor)userObject;
                return descr.toString();
            }
            return (String)TO_STRING.convert((Object)path);
        }
    };

    public TreeSpeedSearch(JTree tree, Convertor<TreePath, String> toStringConvertor) {
        super(tree);
        this.myToStringConvertor = toStringConvertor;
    }

    public TreeSpeedSearch(JTree tree) {
        this(tree, TO_STRING);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString) {
        this(tree, toString, false);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString, boolean canExpand) {
        super(tree);
        this.myToStringConvertor = toString;
        this.myCanExpand = canExpand;
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreeUtil.selectPath((JTree)((JTree)this.myComponent), (TreePath)((TreePath)element));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return ArrayUtil.find((Object[])this.getAllElements(), (Object)((JTree)this.myComponent).getSelectionPath());
        }
        int[] selectionRows = ((JTree)this.myComponent).getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    protected Object[] getAllElements() {
        Object root;
        if (this.myCanExpand && (root = ((JTree)this.myComponent).getModel().getRoot()) instanceof DefaultMutableTreeNode) {
            final ArrayList paths = new ArrayList();
            TreeUtil.traverseDepth((TreeNode)((DefaultMutableTreeNode)root), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                        paths.add(new TreePath(treeNode.getPath()));
                    }
                    return true;
                }
            });
            return paths.toArray(new TreePath[paths.size()]);
        }
        Object[] paths = new TreePath[((JTree)this.myComponent).getRowCount()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ((JTree)this.myComponent).getPathForRow(i);
        }
        return paths;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }
}

