/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Function;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithAutoCompletion
extends EditorTextField {
    private List<LookupElement> myVariants;
    private String myAdText;

    public TextFieldWithAutoCompletion() {
    }

    public TextFieldWithAutoCompletion(Project project) {
        super(TextFieldWithAutoCompletion.createDocument(project), project, PlainTextLanguage.INSTANCE.getAssociatedFileType());
        new VariantsCompletionAction();
    }

    private static Document createDocument(@Nullable Project project) {
        if (project == null) {
            return EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        PlainTextLanguage language = PlainTextLanguage.INSTANCE;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        FileType fileType = language.getAssociatedFileType();
        assert (fileType != null);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = factory.createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)"", stamp, true, false);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        return document;
    }

    public void setAdvertisementText(@Nullable String text) {
        this.myAdText = text;
    }

    public String getAdvertisementText() {
        return this.myAdText;
    }

    public void setVariants(@Nullable List<LookupElement> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    public void setVariants(@Nullable String[] variants) {
        this.myVariants = variants == null ? Collections.emptyList() : ContainerUtil.map((Object[])variants, (Function)new Function<String, LookupElement>(){

            public LookupElement fun(String s) {
                return LookupElementBuilder.create((String)s);
            }
        });
    }

    private LookupElement[] calcLookupItems(@Nullable String lookupPrefix) {
        if (lookupPrefix == null) {
            return new LookupElement[0];
        }
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        if (lookupPrefix.length() == 0) {
            items.addAll(this.myVariants);
        } else {
            NameUtil.Matcher matcher = NameUtil.buildMatcher((String)lookupPrefix, (int)0, (boolean)true, (boolean)true);
            for (LookupElement variant : this.myVariants) {
                if (!matcher.matches(variant.getLookupString())) continue;
                items.add(variant);
            }
        }
        Collections.sort(items, new Comparator<LookupElement>(){

            @Override
            public int compare(LookupElement item1, LookupElement item2) {
                return item1.getLookupString().compareTo(item2.getLookupString());
            }
        });
        return items.toArray(new LookupElement[items.size()]);
    }

    @Nullable
    protected String getCurrentLookupPrefix(String currentTextPrefix) {
        return currentTextPrefix;
    }

    private String getCurrentTextPrefix() {
        return this.getText().substring(0, this.getCaretModel().getOffset());
    }

    private class VariantsCompletionAction
    extends AnAction {
        private VariantsCompletionAction() {
            AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
            if (action != null) {
                this.registerCustomShortcutSet(action.getShortcutSet(), TextFieldWithAutoCompletion.this);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            Editor editor = TextFieldWithAutoCompletion.this.getEditor();
            assert (editor != null);
            editor.getSelectionModel().removeSelection();
            String lookupPrefix = TextFieldWithAutoCompletion.this.getCurrentLookupPrefix(TextFieldWithAutoCompletion.this.getCurrentTextPrefix());
            LookupImpl lookup = (LookupImpl)LookupManager.getInstance(TextFieldWithAutoCompletion.this.getProject()).createLookup(editor, TextFieldWithAutoCompletion.this.calcLookupItems(lookupPrefix), lookupPrefix != null ? lookupPrefix : "", LookupArranger.DEFAULT);
            String advertisementText = TextFieldWithAutoCompletion.this.getAdvertisementText();
            if (!StringUtil.isEmpty((String)advertisementText)) {
                lookup.setAdvertisementText(advertisementText);
                lookup.refreshUi();
            }
            lookup.show();
        }
    }
}

