/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtil;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ReferenceEditorComboWithBrowseButton
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    public ReferenceEditorComboWithBrowseButton(ActionListener browseActionListener, String text, @NotNull PsiManager manager, boolean toAcceptClasses, String recentsKey) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ui/ReferenceEditorComboWithBrowseButton.<init> must not be null");
        }
        super((JComponent)new EditorComboBox(ReferenceEditorComboWithBrowseButton.createDocument(text, manager, toAcceptClasses), manager.getProject(), (FileType)StdFileTypes.JAVA), browseActionListener);
        List<String> recentEntries = RecentsManager.getInstance(manager.getProject()).getRecentEntries(recentsKey);
        if (recentEntries != null) {
            this.setHistory(ArrayUtil.toStringArray(recentEntries));
        }
        if (text != null && text.length() > 0) {
            this.prependItem(text);
        }
    }

    private static Document createDocument(String text, PsiManager manager, boolean isClassesAccepted) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
        PsiJavaCodeReferenceCodeFragment fragment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createReferenceCodeFragment(text, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return PsiDocumentManager.getInstance((Project)manager.getProject()).getDocument((PsiFile)fragment);
    }

    @Override
    public String getText() {
        return ((EditorComboBox)this.getChildComponent()).getText().trim();
    }

    @Override
    public void setText(String text) {
        ((EditorComboBox)this.getChildComponent()).setText(text);
    }

    public boolean isEditable() {
        return !((EditorComboBox)this.getChildComponent()).getEditorEx().isViewer();
    }

    public void setHistory(String[] history) {
        ((EditorComboBox)this.getChildComponent()).setHistory(history);
    }

    public void prependItem(String item) {
        ((EditorComboBox)this.getChildComponent()).prependItem(item);
    }
}

