/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public abstract class FlyIdeaTestCase
extends TestCase {
    private Disposable myRootDisposable;
    private File myTempDir;

    protected void setUp() throws Exception {
        MockApplication app = new MockApplication();
        this.myRootDisposable = Disposer.newDisposable();
        ApplicationManagerEx.setApplication(app, this.myRootDisposable);
    }

    public File getTempDir() throws IOException {
        if (this.myTempDir == null) {
            this.myTempDir = FileUtil.createTempDirectory((String)this.getName(), (String)((Object)((Object)this)).getClass().getName());
        }
        return this.myTempDir;
    }

    public Disposable getRootDisposable() {
        return this.myRootDisposable;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.myTempDir != null) {
            FileUtil.asyncDelete((File)this.myTempDir);
        }
        Disposer.dispose((Disposable)this.myRootDisposable);
    }
}

