/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceHandler
implements CodeInsightActionHandler {
    private final boolean myDataFlowToThis;

    public SliceHandler(boolean dataFlowToThis) {
        this.myDataFlowToThis = dataFlowToThis;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement expression = this.getExpressionAtCaret(editor, file);
        if (expression == null) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find what to analyze. Please stand on the expression or variable or method parameter and try again.");
            return;
        }
        SliceManager sliceManager = SliceManager.getInstance(project);
        sliceManager.slice(expression, this.myDataFlowToThis, this);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getExpressionAtCaret(Editor editor, PsiFile file) {
        int offset = TargetElementUtilBase.adjustOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset == 0) {
            return null;
        }
        PsiElement atCaret = file.findElementAt(offset);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiExpression.class, PsiVariable.class});
        if (this.myDataFlowToThis && element instanceof PsiLiteralExpression) {
            return null;
        }
        return element;
    }

    public SliceAnalysisParams askForParams(PsiElement element, boolean dataFlowToThis, SliceManager.StoredSettingsBean storedSettingsBean, String dialogTitle) {
        AnalysisScope analysisScope = new AnalysisScope(element.getContainingFile());
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        String name = module == null ? null : module.getName();
        Project myProject = element.getProject();
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();
        analysisUIOptions.save(storedSettingsBean.analysisUIOptions);
        BaseAnalysisActionDialog dialog = new BaseAnalysisActionDialog(dialogTitle, "Analyze scope", myProject, analysisScope, name, true, analysisUIOptions, element);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        AnalysisScope scope = dialog.getScope(analysisUIOptions, analysisScope, myProject, module);
        storedSettingsBean.analysisUIOptions.save(analysisUIOptions);
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.scope = scope;
        params.dataFlowToThis = dataFlowToThis;
        return params;
    }
}

