/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class UnwrapCall
extends FixableUsageInfo {
    @NotNull
    private final PsiCallExpression call;
    @NotNull
    private final String unwrapMethod;

    public UnwrapCall(@NotNull PsiCallExpression call, @NotNull String unwrapMethod) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/usageInfo/UnwrapCall.<init> must not be null");
        }
        if (unwrapMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/usageInfo/UnwrapCall.<init> must not be null");
        }
        super((PsiElement)call);
        this.call = call;
        this.unwrapMethod = unwrapMethod;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression = this.call.getText() + '.' + this.unwrapMethod + "()";
        MutationUtils.replaceExpression(newExpression, (PsiExpression)this.call);
    }
}

