/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

class ReturnValueBeanBuilder {
    private String className = null;
    private String packageName = null;
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private Project myProject = null;
    private PsiType valueType = null;
    private boolean myStatic;

    ReturnValueBeanBuilder() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTypeArguments(List<PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setCodeStyleSettings(Project settings) {
        this.myProject = settings;
    }

    public String buildBeanClass() throws IOException {
        StringBuffer out = new StringBuffer(1024);
        if (this.packageName.length() > 0) {
            out.append("package " + this.packageName + ';');
        }
        out.append('\n');
        out.append("public ");
        if (this.myStatic) {
            out.append("static ");
        }
        out.append("class ").append(this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                String parameterText = typeParam.getText();
                out.append(parameterText);
                first = false;
            }
            out.append('>');
        }
        out.append('\n');
        out.append('{');
        this.outputField(out);
        out.append('\n');
        this.outputConstructor(out);
        out.append('\n');
        this.outputGetter(out);
        out.append("}\n");
        return out.toString();
    }

    private void outputGetter(@NonNls StringBuffer out) {
        String typeText = this.valueType.getCanonicalText();
        String name = "value";
        String capitalizedName = StringUtil.capitalize((String)"value");
        out.append("\tpublic " + typeText + " get" + capitalizedName + "()\n");
        out.append("\t{\n");
        String fieldName = this.getFieldName("value");
        out.append("\t\treturn " + fieldName + ";\n");
        out.append("\t}\n");
        out.append('\n');
    }

    private void outputField(@NonNls StringBuffer out) {
        String typeText = this.valueType.getCanonicalText();
        out.append("\tprivate final " + typeText + ' ' + this.getFieldName("value") + ";\n");
    }

    private void outputConstructor(@NonNls StringBuffer out) {
        out.append("\tpublic " + this.className + '(');
        String typeText = this.valueType.getCanonicalText();
        String name = "value";
        String parameterName = JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName("value", VariableKind.PARAMETER);
        out.append(CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS ? "final " : "");
        out.append(typeText + ' ' + parameterName);
        out.append(")\n");
        out.append("\t{\n");
        String fieldName = this.getFieldName("value");
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis." + fieldName + " = " + parameterName + ";\n");
        } else {
            out.append("\t\t" + fieldName + " = " + parameterName + ";\n");
        }
        out.append("\t}\n");
        out.append('\n');
    }

    private String getFieldName(String name) {
        return JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName(name, VariableKind.FIELD);
    }

    public void setValueType(PsiType valueType) {
        this.valueType = valueType;
    }

    public void setStatic(boolean isStatic) {
        this.myStatic = isStatic;
    }
}

