/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JRadioButton;

public class RadioUpDownListener
extends KeyAdapter {
    private final JRadioButton[] myRadioButtons;

    public RadioUpDownListener(JRadioButton ... radioButtons) {
        this.myRadioButtons = radioButtons;
        for (JRadioButton radioButton : radioButtons) {
            radioButton.addKeyListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selected = this.getSelected();
        if (selected != -1) {
            if (e.getKeyCode() == 38) {
                int newIdx = selected - 1;
                if (newIdx < 0) {
                    newIdx = this.myRadioButtons.length - 1;
                }
                RadioUpDownListener.click(this.myRadioButtons[newIdx]);
            } else if (e.getKeyCode() == 40) {
                int newIdx = selected + 1;
                if (newIdx > this.myRadioButtons.length - 1) {
                    newIdx = 0;
                }
                RadioUpDownListener.click(this.myRadioButtons[newIdx]);
            }
        }
    }

    private int getSelected() {
        for (int i = 0; i < this.myRadioButtons.length; ++i) {
            if (!this.myRadioButtons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private static void click(JRadioButton button) {
        if (button.isEnabled()) {
            button.requestFocus();
            button.doClick();
        }
    }
}

