/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FixableUsagesRefactoringProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + FixableUsagesRefactoringProcessor.class.getName()));

    protected FixableUsagesRefactoringProcessor(Project project) {
        super(project);
    }

    @Override
    protected void refreshElements(PsiElement[] psiElements) {
    }

    @Override
    protected void performRefactoring(UsageInfo[] usageInfos) {
        RefactoringUtil.sortDepthFirstRightLeftOrder(usageInfos);
        for (UsageInfo usageInfo : usageInfos) {
            if (!(usageInfo instanceof FixableUsageInfo)) continue;
            try {
                ((FixableUsageInfo)usageInfo).fixUsage();
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    protected final UsageInfo[] findUsages() {
        ArrayList<FixableUsageInfo> usages = new ArrayList<FixableUsageInfo>();
        this.findUsages(usages);
        int numUsages = usages.size();
        UsageInfo[] usageArray = usages.toArray(new FixableUsageInfo[numUsages]);
        if (usageArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/FixableUsagesRefactoringProcessor.findUsages must not return null");
        }
        return usageArray;
    }

    protected abstract void findUsages(@NotNull List<FixableUsageInfo> var1);

    protected static void checkConflicts(Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo info : (UsageInfo[])refUsages.get()) {
            String conflict = ((FixableUsageInfo)info).getConflictMessage();
            if (conflict == null) continue;
            conflicts.putValue((Object)info.getElement(), (Object)XmlUtil.escape(conflict));
        }
    }
}

