/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public abstract class RefactoringDialog
extends DialogWrapper {
    private Action myRefactorAction;
    private Action myPreviewAction;
    private boolean myCbPreviewResults;
    protected final Project myProject;

    protected RefactoringDialog(@NotNull Project project, boolean canBeParent) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/RefactoringDialog.<init> must not be null");
        }
        super(project, canBeParent);
        this.myCbPreviewResults = true;
        this.myProject = project;
    }

    public final boolean isPreviewUsages() {
        return this.myCbPreviewResults;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRefactorAction = new RefactorAction();
        this.myPreviewAction = new PreviewAction();
    }

    protected final Action getRefactorAction() {
        return this.myRefactorAction;
    }

    protected final Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected abstract void doAction();

    private void doPreviewAction() {
        this.myCbPreviewResults = true;
        this.doAction();
    }

    protected void doRefactorAction() {
        this.myCbPreviewResults = false;
        this.doAction();
    }

    protected final void closeOKAction() {
        super.doOKAction();
    }

    protected final void doOKAction() {
        this.doAction();
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(null);
        }
    }

    protected void validateButtons() {
        boolean enabled = true;
        try {
            this.setErrorText(null);
            this.canRun();
        }
        catch (ConfigurationException e) {
            enabled = false;
            this.setErrorText(e.getMessage());
        }
        this.getPreviewAction().setEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
    }

    protected boolean hasHelpAction() {
        return true;
    }

    protected Action[] createActions() {
        if (this.hasHelpAction()) {
            return new Action[]{this.getRefactorAction(), this.getPreviewAction(), this.getCancelAction(), this.getHelpAction()};
        }
        return new Action[]{this.getRefactorAction(), this.getPreviewAction(), this.getCancelAction()};
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        Runnable prepareSuccessfulCallback = new Runnable(){

            @Override
            public void run() {
                RefactoringDialog.this.close(0);
            }
        };
        processor.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor.setPreviewUsages(this.isPreviewUsages());
        processor.run();
    }

    private class PreviewAction
    extends AbstractAction {
        public PreviewAction() {
            this.putValue("Name", RefactoringBundle.message((String)"preview.button"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doPreviewAction();
        }
    }

    private class RefactorAction
    extends AbstractAction {
        public RefactorAction() {
            this.putValue("Name", RefactoringBundle.message((String)"refactor.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doRefactorAction();
        }
    }
}

