/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.psi.PsiClass;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ClassCellRenderer
extends DefaultListCellRenderer {
    private final boolean myShowReadOnly;

    public ClassCellRenderer() {
        this.setOpaque(true);
        this.myShowReadOnly = true;
    }

    public ClassCellRenderer(boolean showReadOnly) {
        this.setOpaque(true);
        this.myShowReadOnly = showReadOnly;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            return ClassCellRenderer.customizeRenderer(this, value, this.myShowReadOnly);
        }
        return rendererComponent;
    }

    public static JLabel customizeRenderer(JLabel cellRendererComponent, @NotNull Object value, boolean showReadOnly) {
        Icon icon;
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/ui/ClassCellRenderer.customizeRenderer must not be null");
        }
        PsiClass aClass = (PsiClass)value;
        cellRendererComponent.setText(ClassCellRenderer.getClassText(aClass));
        int flags = 1;
        if (showReadOnly) {
            flags |= 2;
        }
        if ((icon = aClass.getIcon(flags)) != null) {
            cellRendererComponent.setIcon(icon);
        }
        return cellRendererComponent;
    }

    private static String getClassText(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/ClassCellRenderer.getClassText must not be null");
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        String name = aClass.getName();
        if (name != null) {
            return name;
        }
        return RefactoringBundle.message((String)"anonymous.class.text");
    }
}

