/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NonNls;

public class ConstructorParameterOnFieldRenameRenamer
extends AutomaticRenamer {
    @Override
    @NonNls
    protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
        return JavaCodeStyleManager.getInstance((Project)element.getProject()).propertyNameToVariableName(canonicalName, VariableKind.PARAMETER);
    }

    @Override
    protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
        return JavaCodeStyleManager.getInstance((Project)element.getProject()).variableNameToPropertyName(name, VariableKind.FIELD);
    }

    public ConstructorParameterOnFieldRenameRenamer(PsiField aField, String newFieldName) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)aField.getProject());
        String propertyName = styleManager.variableNameToPropertyName(aField.getName(), VariableKind.FIELD);
        if (!Comparing.strEqual((String)propertyName, (String)styleManager.variableNameToPropertyName(newFieldName, VariableKind.FIELD))) {
            String paramName = styleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiClass aClass = aField.getContainingClass();
            for (PsiMethod constructor : aClass.getConstructors()) {
                PsiParameter[] parameters;
                for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
                    if (!paramName.equals(parameter.getName())) continue;
                    this.myElements.add(parameter);
                }
            }
            this.suggestAllNames(aField.getName(), newFieldName);
        }
    }

    @Override
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.constructor.parameters.title");
    }

    @Override
    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.constructor.parameters.with.the.following.names.to");
    }

    @Override
    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.constructor.parameter");
    }
}

