/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public abstract class AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.naming.AutomaticRenamer");
    private final LinkedHashMap<PsiNamedElement, String> myRenames = new LinkedHashMap();
    protected final List<PsiNamedElement> myElements = new ArrayList<PsiNamedElement>();

    protected AutomaticRenamer() {
    }

    public boolean hasAnythingToRename() {
        Collection<String> strings = this.myRenames.values();
        for (String s : strings) {
            if (s == null) continue;
            return true;
        }
        return false;
    }

    public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles) {
        Iterator<PsiNamedElement> iterator = this.myElements.iterator();
        while (iterator.hasNext()) {
            PsiNamedElement variable = iterator.next();
            boolean success = this.findUsagesForElement(variable, result, searchInStringsAndComments, searchInNonJavaFiles);
            if (success) continue;
            iterator.remove();
        }
    }

    private boolean findUsagesForElement(PsiNamedElement element, List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles) {
        String newName = this.getNewName(element);
        if (newName != null) {
            UsageInfo[] usages;
            for (UsageInfo usage : usages = RenameUtil.findUsages((PsiElement)element, newName, searchInStringsAndComments, searchInNonJavaFiles, this.myRenames)) {
                if (!(usage instanceof UnresolvableCollisionUsageInfo)) continue;
                return false;
            }
            result.addAll(Arrays.asList(usages));
        }
        return true;
    }

    public List<PsiNamedElement> getElements() {
        return Collections.unmodifiableList(this.myElements);
    }

    public String getNewName(PsiNamedElement namedElement) {
        return this.myRenames.get(namedElement);
    }

    public Map<PsiNamedElement, String> getRenames() {
        return Collections.unmodifiableMap(this.myRenames);
    }

    public void setRename(PsiNamedElement element, String replacement) {
        LOG.assertTrue(this.myRenames.put(element, replacement) != null);
    }

    public void doNotRename(PsiNamedElement element) {
        LOG.assertTrue(this.myRenames.remove(element) != null);
    }

    protected void suggestAllNames(String oldClassName, String newClassName) {
        NameSuggester suggester = new NameSuggester(oldClassName, newClassName);
        for (int varIndex = this.myElements.size() - 1; varIndex >= 0; --varIndex) {
            PsiNamedElement element = this.myElements.get(varIndex);
            String name = element.getName();
            if (!this.myRenames.containsKey(element)) {
                String newName;
                String canonicalName = this.nameToCanonicalName(name, element);
                String newCanonicalName = suggester.suggestName(canonicalName);
                if (newCanonicalName.length() == 0) {
                    LOG.error("oldClassName = " + oldClassName + ", newClassName = " + newClassName + ", name = " + name + ", canonicalName = " + canonicalName + ", newCanonicalName = " + newCanonicalName);
                }
                if (!(newName = this.canonicalNameToName(newCanonicalName, element)).equals(name)) {
                    this.myRenames.put(element, newName);
                } else {
                    this.myRenames.put(element, null);
                }
            }
            if (this.myRenames.get(element) != null) continue;
            this.myElements.remove(varIndex);
        }
    }

    @NonNls
    protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
        return canonicalName;
    }

    protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
        return name;
    }

    public boolean isSelectedByDefault() {
        return false;
    }

    public abstract String getDialogTitle();

    public abstract String getDialogDescription();

    public abstract String entityName();
}

