/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MoveJavaMemberHandler
implements MoveMemberHandler {
    @Override
    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(PsiMember member, PsiReference psiReference, Set<PsiMember> membersToMove, PsiClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (ref instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
                if (!MoveJavaMemberHandler.isInMovedElement((PsiElement)refExpr, membersToMove) ? qualifier != null : qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    private static boolean isInMovedElement(PsiElement element, Set<PsiMember> membersToMove) {
        for (PsiMember member : membersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean changeExternalUsage(MoveMembersOptions options, MoveMembersProcessor.MoveMembersUsageInfo usage) {
        if (!usage.getElement().isValid()) {
            return true;
        }
        if (usage.reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)usage.reference;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null) {
                    MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    refExpr.setQualifierExpression(null);
                }
            } else if (usage.qualifierClass != null) {
                MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    @Override
    public PsiMember doMove(MoveMembersOptions options, PsiMember member, PsiElement anchor, PsiClass targetClass) {
        PsiMember memberCopy;
        if (member instanceof PsiVariable) {
            ((PsiVariable)member).normalizeDeclaration();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)member, true);
        if (targetClass == null) {
            return null;
        }
        if (options.makeEnumConstant() && member instanceof PsiVariable && EnumConstantsUtil.isSuitableForEnumConstant(((PsiVariable)member).getType(), targetClass)) {
            memberCopy = EnumConstantsUtil.createEnumConstant(targetClass, member.getName(), ((PsiVariable)member).getInitializer());
        } else {
            memberCopy = (PsiMember)member.copy();
            if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = memberCopy.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        }
        member.delete();
        return anchor != null ? (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor) : (PsiMember)targetClass.add((PsiElement)memberCopy);
    }

    @Override
    public void decodeContextInfo(PsiElement scope) {
        ChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    private static void changeQualifier(PsiReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (RefactoringUtil.hasOnDemandStaticImport((PsiElement)refExpr, aClass)) {
            refExpr.setQualifierExpression(null);
        } else if (!RefactoringUtil.hasStaticImportOn((PsiElement)refExpr, member)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory();
            refExpr.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    @Override
    @Nullable
    public PsiElement getAnchor(PsiMember member, final PsiClass targetClass) {
        if (member instanceof PsiField && member.hasModifierProperty("static")) {
            final ArrayList afterFields = new ArrayList();
            PsiExpression psiExpression = ((PsiField)member).getInitializer();
            if (psiExpression != null) {
                psiExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiField psiField;
                        super.visitReferenceExpression(expression);
                        PsiElement psiElement = expression.resolve();
                        if (psiElement instanceof PsiField && (psiField = (PsiField)psiElement).getContainingClass() == targetClass && !afterFields.contains(psiField)) {
                            afterFields.add(psiField);
                        }
                    }
                });
            }
            Comparator<PsiField> fieldComparator = new Comparator<PsiField>(){

                @Override
                public int compare(PsiField o1, PsiField o2) {
                    return -PsiUtilBase.compareElementsByPosition((PsiElement)o1, (PsiElement)o2);
                }
            };
            if (!afterFields.isEmpty()) {
                Collections.sort(afterFields, fieldComparator);
                return (PsiElement)afterFields.get(0);
            }
            ArrayList<PsiField> beforeFields = new ArrayList<PsiField>();
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)targetClass))) {
                PsiField fieldWithReference = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiField.class);
                if (fieldWithReference == null || afterFields.contains(fieldWithReference)) continue;
                beforeFields.add(fieldWithReference);
            }
            Collections.sort(beforeFields, fieldComparator);
            if (!beforeFields.isEmpty()) {
                return ((PsiField)beforeFields.get(0)).getPrevSibling();
            }
        }
        return null;
    }
}

