/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PullUpConflictsUtil {
    private PullUpConflictsUtil() {
    }

    public static MultiMap<PsiElement, String> checkConflicts(MemberInfo[] infos, PsiClass subclass, @Nullable PsiClass superClass, PsiPackage targetPackage, PsiDirectory targetDirectory, InterfaceContainmentVerifier interfaceContainmentVerifier) {
        PsiDirectory targetRepresentativeElement;
        boolean isInterfaceTarget;
        HashSet<PsiMember> movedMembers = new HashSet<PsiMember>();
        HashSet<PsiMethod> abstractMethods = new HashSet<PsiMethod>();
        if (superClass != null) {
            isInterfaceTarget = superClass.isInterface();
            targetRepresentativeElement = superClass;
        } else {
            isInterfaceTarget = false;
            targetRepresentativeElement = targetDirectory;
        }
        for (MemberInfo info : infos) {
            PsiMember member = (PsiMember)info.getMember();
            if (member instanceof PsiMethod) {
                if (!info.isToAbstract() && !isInterfaceTarget) {
                    movedMembers.add(member);
                    continue;
                }
                abstractMethods.add((PsiMethod)member);
                continue;
            }
            movedMembers.add(member);
        }
        MultiMap conflicts = new MultiMap();
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(movedMembers, superClass, (MultiMap<PsiElement, String>)conflicts, null, (PsiElement)targetRepresentativeElement, abstractMethods);
        if (superClass != null) {
            PullUpConflictsUtil.checkSuperclassMembers(superClass, infos, (MultiMap<PsiElement, String>)conflicts);
            if (isInterfaceTarget) {
                PullUpConflictsUtil.checkInterfaceTarget(infos, (MultiMap<PsiElement, String>)conflicts);
            }
        }
        ArrayList<Object> checkModuleConflictsList = new ArrayList<Object>();
        for (PsiMember member : movedMembers) {
            if (member instanceof PsiMethod || member instanceof PsiClass && !(member instanceof PsiCompiledElement)) {
                ConflictingUsagesOfSubClassMembers visitor = new ConflictingUsagesOfSubClassMembers((PsiElement)member, movedMembers, abstractMethods, subclass, superClass, superClass != null ? null : targetPackage, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier);
                member.accept((PsiElementVisitor)visitor);
            }
            checkModuleConflictsList.add(member);
        }
        for (PsiMethod method : abstractMethods) {
            checkModuleConflictsList.add(method.getParameterList());
            checkModuleConflictsList.add(method.getReturnTypeElement());
            checkModuleConflictsList.add(method.getTypeParameterList());
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsList, new UsageInfo[0], (PsiElement)targetRepresentativeElement, (MultiMap<PsiElement, String>)conflicts);
        return conflicts;
    }

    private static void checkInterfaceTarget(MemberInfo[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfo info : infos) {
            String message;
            PsiElement member = info.getMember();
            if (!(!(member instanceof PsiField) && !(member instanceof PsiClass) || ((PsiModifierListOwner)member).hasModifierProperty("static") || member instanceof PsiClass && ((PsiClass)member).isInterface())) {
                message = RefactoringBundle.message((String)"0.is.not.static.it.cannot.be.moved.to.the.interface", (Object[])new Object[]{RefactoringUIUtil.getDescription(member, false)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflictsList.putValue((Object)member, (Object)message);
            }
            if (!(member instanceof PsiField) || ((PsiField)member).getInitializer() != null) continue;
            message = RefactoringBundle.message((String)"0.is.not.initialized.in.declaration.such.fields.are.not.allowed.in.interfaces", (Object[])new Object[]{RefactoringUIUtil.getDescription(member, false)});
            conflictsList.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
    }

    private static void checkSuperclassMembers(PsiClass superClass, MemberInfo[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfo info : infos) {
            PsiMethod method;
            PsiModifierList modifierList;
            PsiMember member = (PsiMember)info.getMember();
            boolean isConflict = false;
            if (member instanceof PsiField) {
                String name = member.getName();
                isConflict = superClass.findFieldByName(name, false) != null;
            } else if (member instanceof PsiMethod) {
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)member.getContainingClass(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature signature = ((PsiMethod)member).getSignature(superSubstitutor);
                PsiMethod superClassMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)superClass, (MethodSignature)signature, (boolean)false);
                boolean bl = isConflict = superClassMethod != null;
            }
            if (isConflict) {
                String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)superClass, false), RefactoringUIUtil.getDescription((PsiElement)member, false)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflictsList.putValue((Object)superClass, (Object)message);
            }
            if (!(member instanceof PsiMethod) || (modifierList = (method = (PsiMethod)member).getModifierList()).hasModifierProperty("private")) continue;
            for (PsiClass subClass : ClassInheritorsSearch.search((PsiClass)superClass)) {
                MethodSignature signature;
                PsiMethod wouldBeOverriden;
                if (method.getContainingClass() == subClass || (wouldBeOverriden = MethodSignatureUtil.findMethodBySignature((PsiClass)subClass, (MethodSignature)(signature = ((PsiMethod)member).getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)subClass, (PsiSubstitutor)PsiSubstitutor.EMPTY))), (boolean)false)) == null || VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)wouldBeOverriden.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList)) <= 0) continue;
                conflictsList.putValue((Object)wouldBeOverriden, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)method, true) + " in super class would clash with local method from " + RefactoringUIUtil.getDescription((PsiElement)subClass, true))));
            }
        }
    }

    private static class ConflictingUsagesOfSubClassMembers
    extends ClassMemberReferencesVisitor {
        private final PsiElement myScope;
        private final Set<PsiMember> myMovedMembers;
        private final Set<PsiMethod> myAbstractMethods;
        private final PsiClass mySubclass;
        private final PsiClass mySuperClass;
        private final PsiPackage myTargetPackage;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final InterfaceContainmentVerifier myInterfaceContainmentVerifier;

        ConflictingUsagesOfSubClassMembers(PsiElement scope, Set<PsiMember> movedMembers, Set<PsiMethod> abstractMethods, PsiClass subclass, PsiClass superClass, PsiPackage targetPackage, MultiMap<PsiElement, String> conflictsList, InterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySubclass = subclass;
            this.mySuperClass = superClass;
            this.myTargetPackage = targetPackage;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (classMember != null && RefactoringHierarchyUtil.isMemberBetween(this.mySuperClass, this.mySubclass, classMember)) {
                if (classMember.hasModifierProperty("static") && !this.willBeMoved((PsiElement)classMember)) {
                    boolean isAccessible = this.mySuperClass != null ? PsiUtil.isAccessible((PsiMember)classMember, (PsiElement)this.mySuperClass, null) : (this.myTargetPackage != null ? PsiUtil.isAccessibleFromPackage((PsiModifierListOwner)classMember, (PsiPackage)this.myTargetPackage) : classMember.hasModifierProperty("public"));
                    if (!isAccessible) {
                        String message = RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.myScope, false), RefactoringUIUtil.getDescription((PsiElement)classMember, true)});
                        message = CommonRefactoringUtil.capitalize((String)message);
                        this.myConflictsList.putValue((Object)classMember, (Object)message);
                    }
                    return;
                }
                if (!(this.myAbstractMethods.contains(classMember) || this.willBeMoved((PsiElement)classMember) || this.existsInSuperClass((PsiElement)classMember))) {
                    String message = RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.myScope, false), RefactoringUIUtil.getDescription((PsiElement)classMember, true)});
                    message = CommonRefactoringUtil.capitalize((String)message);
                    this.myConflictsList.putValue((Object)classMember, (Object)message);
                }
            }
        }

        private boolean willBeMoved(PsiElement element) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!this.myMovedMembers.contains(parent)) continue;
                return true;
            }
            return false;
        }

        private boolean existsInSuperClass(PsiElement classMember) {
            if (!(classMember instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            PsiMethod methodBySignature = this.mySuperClass.findMethodBySignature(method, true);
            return methodBySignature != null;
        }
    }
}

