/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterViewDescriptor;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.BaseOccurenceManager;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.refactoring.util.occurences.LocalVariableOccurenceManager;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterProcessor
extends BaseRefactoringProcessor
implements IntroduceParameterData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor");
    private final PsiMethod myMethodToReplaceIn;
    private final PsiMethod myMethodToSearchFor;
    private PsiExpression myParameterInitializer;
    private final PsiExpression myExpressionToSearch;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myRemoveLocalVariable;
    private final String myParameterName;
    private final boolean myReplaceAllOccurences;
    private int myReplaceFieldsWithGetters;
    private final boolean myDeclareFinal;
    private final boolean myGenerateDelegate;
    private PsiType myForcedType;
    private final TIntArrayList myParametersToRemove;
    private final PsiManager myManager;

    public IntroduceParameterProcessor(@NotNull Project project, PsiMethod methodToReplaceIn, @NotNull PsiMethod methodToSearchFor, PsiExpression parameterInitializer, PsiExpression expressionToSearch, PsiLocalVariable localVariable, boolean removeLocalVariable, String parameterName, boolean replaceAllOccurences, int replaceFieldsWithGetters, boolean declareFinal, boolean generateDelegate, PsiType forcedType, @NotNull TIntArrayList parametersToRemove) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.<init> must not be null");
        }
        if (methodToSearchFor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.<init> must not be null");
        }
        if (parametersToRemove == null) {
            throw new IllegalArgumentException("Argument 13 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.<init> must not be null");
        }
        super(project);
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myParameterInitializer = parameterInitializer;
        this.myExpressionToSearch = expressionToSearch;
        this.myLocalVariable = localVariable;
        this.myRemoveLocalVariable = removeLocalVariable;
        this.myParameterName = parameterName;
        this.myReplaceAllOccurences = replaceAllOccurences;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myDeclareFinal = declareFinal;
        this.myGenerateDelegate = generateDelegate;
        this.myForcedType = forcedType;
        this.myManager = PsiManager.getInstance((Project)project);
        this.myParametersToRemove = parametersToRemove;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new IntroduceParameterViewDescriptor(this.myMethodToSearchFor);
    }

    @Override
    public PsiType getForcedType() {
        return this.myForcedType;
    }

    public void setForcedType(PsiType forcedType) {
        this.myForcedType = forcedType;
    }

    @Override
    public int getReplaceFieldsWithGetters() {
        return this.myReplaceFieldsWithGetters;
    }

    public void setReplaceFieldsWithGetters(int replaceFieldsWithGetters) {
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiMethod[] overridingMethods;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)this.myMethodToSearchFor, (SearchScope)this.myMethodToSearchFor.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            result.add(new UsageInfo((PsiElement)overridingMethod));
        }
        if (!this.myGenerateDelegate) {
            PsiReference[] refs;
            for (PsiReference ref1 : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)this.myMethodToSearchFor, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement ref = ref1.getElement();
                if (ref instanceof PsiMethod && ((PsiMethod)ref).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)ref, ((PsiMethod)ref).getContainingClass(), this.myMethodToSearchFor);
                    result.add(implicitUsageInfo);
                    continue;
                }
                if (ref instanceof PsiClass) {
                    result.add(new NoConstructorClassUsageInfo((PsiClass)ref));
                    continue;
                }
                if (!this.insideMethodToBeReplaced(ref)) {
                    result.add(new ExternalUsageInfo(ref));
                    continue;
                }
                result.add(new ChangedMethodCallInfo(ref));
            }
        }
        if (this.myReplaceAllOccurences) {
            PsiExpression[] exprs;
            BaseOccurenceManager occurenceManager = this.myLocalVariable == null ? new ExpressionOccurenceManager(this.myExpressionToSearch, (PsiElement)this.myMethodToReplaceIn, null) : new LocalVariableOccurenceManager(this.myLocalVariable, null);
            for (PsiExpression expr : exprs = occurenceManager.getOccurences()) {
                result.add(new InternalUsageInfo((PsiElement)expr));
            }
        } else if (this.myExpressionToSearch != null) {
            result.add(new InternalUsageInfo((PsiElement)this.myExpressionToSearch));
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        AnySameNameVariables anySameNameVariables = new AnySameNameVariables();
        this.myMethodToReplaceIn.accept((PsiElementVisitor)anySameNameVariables);
        Pair<PsiElement, String> conflictPair = anySameNameVariables.getConflict();
        if (conflictPair != null) {
            conflicts.putValue(conflictPair.first, conflictPair.second);
        }
        if (!this.myGenerateDelegate) {
            this.detectAccessibilityConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        }
        if (this.myParameterInitializer != null && !this.myMethodToReplaceIn.hasModifierProperty("private")) {
            AnySupers anySupers = new AnySupers();
            this.myParameterInitializer.accept((PsiElementVisitor)anySupers);
            if (anySupers.isResult()) {
                for (UsageInfo usageInfo : usagesIn) {
                    if (usageInfo.getElement() instanceof PsiMethod || usageInfo instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)this.myMethodToReplaceIn.getContainingClass(), (PsiElement)usageInfo.getElement(), (boolean)false)) continue;
                    conflicts.putValue((Object)this.myParameterInitializer, (Object)RefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")}));
                    break;
                }
            }
        }
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            processor.findConflicts(this, (UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)conflicts);
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private void detectAccessibilityConflicts(UsageInfo[] usageArray, MultiMap<PsiElement, String> conflicts) {
        if (this.myParameterInitializer != null) {
            ReferencedElementsCollector collector = new ReferencedElementsCollector();
            this.myParameterInitializer.accept((PsiElementVisitor)collector);
            Set result = collector.myResult;
            if (!result.isEmpty()) {
                for (UsageInfo usageInfo : usageArray) {
                    if (!(usageInfo instanceof ExternalUsageInfo) || !IntroduceParameterProcessor.isMethodUsage(usageInfo)) continue;
                    PsiElement place = usageInfo.getElement();
                    for (PsiElement element : result) {
                        if (element instanceof PsiField && this.myReplaceFieldsWithGetters != 0) {
                            PsiClass psiClass = ((PsiField)element).getContainingClass();
                            LOG.assertTrue(psiClass != null);
                            PsiMethod method = psiClass.findMethodBySignature(PropertyUtil.generateGetterPrototype((PsiField)((PsiField)element)), true);
                            if (method != null) {
                                element = method;
                            }
                        }
                        if (!(element instanceof PsiMember) || JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)element, place, null)) continue;
                        String message = RefactoringBundle.message((String)"0.is.not.accesible.from.1.value.for.introduced.parameter.in.that.method.call.will.be.incorrect", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(place), true)});
                        conflicts.putValue((Object)element, (Object)message);
                    }
                }
            }
        }
    }

    private static boolean isMethodUsage(UsageInfo usageInfo) {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.isMethodUsage(usageInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean insideMethodToBeReplaced(PsiElement methodUsage) {
        for (PsiElement parent = methodUsage.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(this.myMethodToReplaceIn)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(this.myForcedType, this.myParameterInitializer, this.myLocalVariable);
            this.setForcedType(initializerType);
            if (this.myParameterInitializer == null) {
                LOG.assertTrue(this.myLocalVariable != null);
                this.myParameterInitializer = factory.createExpressionFromText(this.myLocalVariable.getName(), (PsiElement)this.myLocalVariable);
            } else {
                this.myParameterInitializer = RefactoringUtil.convertInitializerToNormalExpression(this.myParameterInitializer, initializerType);
            }
            for (UsageInfo usage : usages) {
                if (usage instanceof InternalUsageInfo) continue;
                if (usage instanceof DefaultConstructorImplicitUsageInfo) {
                    this.addSuperCall(usage, usages);
                    continue;
                }
                if (usage instanceof NoConstructorClassUsageInfo) {
                    this.addDefaultConstructor(usage, usages);
                    continue;
                }
                PsiElement element = usage.getElement();
                if (element instanceof PsiMethod) {
                    if (this.myManager.areElementsEquivalent(element, (PsiElement)this.myMethodToReplaceIn)) continue;
                    this.changeMethodSignatureAndResolveFieldConflicts(usage, usages);
                    continue;
                }
                if (this.myGenerateDelegate) continue;
                this.changeExternalUsage(usage, usages);
            }
            if (this.myGenerateDelegate) {
                this.generateDelegate();
            }
            LOG.assertTrue(initializerType.isValid());
            FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(this.myParameterName, this.myMethodToReplaceIn.getBody());
            this.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToReplaceIn), usages);
            if (this.myMethodToSearchFor != this.myMethodToReplaceIn) {
                this.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToSearchFor), usages);
            }
            ChangeContextUtil.clearContextInfo((PsiElement)this.myParameterInitializer);
            for (UsageInfo usage : usages) {
                PsiElement element;
                if (usage instanceof ChangedMethodCallInfo) {
                    element = usage.getElement();
                    this.processChangedMethodCall(element);
                    continue;
                }
                if (!(usage instanceof InternalUsageInfo)) continue;
                element = usage.getElement();
                if (element instanceof PsiExpression) {
                    element = RefactoringUtil.outermostParenthesizedExpression((PsiExpression)element);
                }
                if (element.getParent() instanceof PsiExpressionStatement) {
                    element.getParent().delete();
                    continue;
                }
                PsiExpression newExpr = factory.createExpressionFromText(this.myParameterName, element);
                IntroduceVariableBase.replace((PsiExpression)element, newExpr, this.myProject);
            }
            if (this.myLocalVariable != null && this.myRemoveLocalVariable) {
                this.myLocalVariable.normalizeDeclaration();
                this.myLocalVariable.getParent().delete();
            }
            fieldConflictsResolver.fix();
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    private void generateDelegate() throws IncorrectOperationException {
        PsiMethod delegate = (PsiMethod)this.myMethodToReplaceIn.copy();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        ChangeSignatureProcessor.makeEmptyBody(elementFactory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, delegate.getName());
        PsiExpressionList argumentList = callExpression.getArgumentList();
        assert (argumentList != null);
        PsiParameter[] psiParameters = this.myMethodToReplaceIn.getParameterList().getParameters();
        PsiParameter anchorParameter = IntroduceParameterProcessor.getAnchorParameter(this.myMethodToReplaceIn);
        if (psiParameters.length == 0) {
            argumentList.add((PsiElement)this.myParameterInitializer);
        } else {
            for (int i = 0; i < psiParameters.length; ++i) {
                PsiParameter psiParameter = psiParameters[i];
                if (!this.myParametersToRemove.contains(i)) {
                    PsiExpression expression = elementFactory.createExpressionFromText(psiParameter.getName(), (PsiElement)delegate);
                    argumentList.add((PsiElement)expression);
                }
                if (psiParameter != anchorParameter) continue;
                argumentList.add((PsiElement)this.myParameterInitializer);
            }
        }
        this.myMethodToReplaceIn.getContainingClass().addBefore((PsiElement)delegate, (PsiElement)this.myMethodToReplaceIn);
    }

    private void addDefaultConstructor(UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processAddDefaultConstructor(this, usage, usages)) break;
        }
    }

    private void addSuperCall(UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processAddSuperCall(this, usage, usages)) break;
        }
    }

    static PsiType getInitializerType(PsiType forcedType, PsiExpression parameterInitializer, PsiLocalVariable localVariable) {
        PsiType initializerType;
        if (forcedType == null) {
            if (parameterInitializer == null) {
                if (localVariable != null) {
                    initializerType = localVariable.getType();
                } else {
                    LOG.assertTrue(false);
                    initializerType = null;
                }
            } else {
                initializerType = localVariable == null ? RefactoringUtil.getTypeByExpressionWithExpectedType(parameterInitializer) : localVariable.getType();
            }
        } else {
            initializerType = forcedType;
        }
        return initializerType;
    }

    private void processChangedMethodCall(PsiElement element) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element.getParent();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)methodCall.getProject()).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText(this.myParameterName, null);
            PsiExpressionList argList = methodCall.getArgumentList();
            PsiExpression[] exprs = argList.getExpressions();
            if (exprs.length > 0) {
                argList.addAfter((PsiElement)expression, (PsiElement)exprs[exprs.length - 1]);
            } else {
                argList.add((PsiElement)expression);
            }
            this.removeParametersFromCall(argList);
        } else {
            LOG.error((Object)element.getParent());
        }
    }

    private void removeParametersFromCall(PsiExpressionList argList) {
        final PsiExpression[] exprs = argList.getExpressions();
        this.myParametersToRemove.forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    exprs[paramNum].delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                return true;
            }
        });
    }

    private void changeExternalUsage(UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processChangeMethodUsage(this, usage, usages)) break;
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"introduce.parameter.command", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.myMethodToReplaceIn)});
    }

    private void changeMethodSignatureAndResolveFieldConflicts(UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processChangeMethodSignature(this, usage, usages)) break;
        }
    }

    @Nullable
    private static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameter anchorParameter;
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        if (!methodToReplaceIn.isVarArgs()) {
            anchorParameter = length > 0 ? parameters[length - 1] : null;
        } else {
            LOG.assertTrue(length > 0);
            LOG.assertTrue(parameters[length - 1].isVarArgs());
            anchorParameter = length > 1 ? parameters[length - 2] : null;
        }
        return anchorParameter;
    }

    @Override
    public PsiMethod getMethodToReplaceIn() {
        return this.myMethodToReplaceIn;
    }

    @Override
    @NotNull
    public PsiMethod getMethodToSearchFor() {
        PsiMethod psiMethod = this.myMethodToSearchFor;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.getMethodToSearchFor must not return null");
        }
        return psiMethod;
    }

    @Override
    public PsiExpression getParameterInitializer() {
        return this.myParameterInitializer;
    }

    @Override
    public PsiExpression getExpressionToSearch() {
        return this.myExpressionToSearch;
    }

    @Override
    public PsiLocalVariable getLocalVariable() {
        return this.myLocalVariable;
    }

    @Override
    public boolean isRemoveLocalVariable() {
        return this.myRemoveLocalVariable;
    }

    @Override
    @NotNull
    public String getParameterName() {
        String string = this.myParameterName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.getParameterName must not return null");
        }
        return string;
    }

    @Override
    public boolean isReplaceAllOccurences() {
        return this.myReplaceAllOccurences;
    }

    @Override
    public boolean isDeclareFinal() {
        return this.myDeclareFinal;
    }

    @Override
    public boolean isGenerateDelegate() {
        return this.myGenerateDelegate;
    }

    @Override
    @NotNull
    public TIntArrayList getParametersToRemove() {
        TIntArrayList tIntArrayList = this.myParametersToRemove;
        if (tIntArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.getParametersToRemove must not return null");
        }
        return tIntArrayList;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor.getProject must not return null");
        }
        return project;
    }

    public class AnySameNameVariables
    extends JavaRecursiveElementWalkingVisitor {
        private Pair<PsiElement, String> conflict = null;

        public Pair<PsiElement, String> getConflict() {
            return this.conflict;
        }

        public void visitVariable(PsiVariable variable) {
            if (variable == IntroduceParameterProcessor.this.myLocalVariable) {
                return;
            }
            if (IntroduceParameterProcessor.this.myParameterName.equals(variable.getName())) {
                String descr = RefactoringBundle.message((String)"there.is.already.a.0.it.will.conflict.with.an.introduced.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, true)});
                this.conflict = Pair.create((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)descr));
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitElement(PsiElement element) {
            if (this.conflict != null) {
                return;
            }
            super.visitElement(element);
        }
    }

    public static class AnySupers
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myResult = false;

        public void visitSuperExpression(PsiSuperExpression expression) {
            this.myResult = true;
        }

        public boolean isResult() {
            return this.myResult;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement((PsiElement)expression);
        }
    }

    private static class ReferencedElementsCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiElement> myResult = new HashSet();

        private ReferencedElementsCollector() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement element = reference.resolve();
            if (element != null) {
                this.myResult.add(element);
            }
        }
    }
}

