/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceInstanceVariableIncrementDecrement
extends FixableUsageInfo {
    private final PsiExpression reference;
    private final String setterName;
    private final String getterName;
    private final String delegateName;

    public ReplaceInstanceVariableIncrementDecrement(PsiExpression reference, String delegateName, String setterName, String getterName) {
        super((PsiElement)reference);
        this.getterName = getterName;
        this.setterName = setterName;
        this.delegateName = delegateName;
        PsiPrefixExpression prefixExpr = (PsiPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiPrefixExpression.class);
        this.reference = prefixExpr != null ? prefixExpr : (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiPostfixExpression.class);
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression;
        PsiJavaToken sign;
        PsiReferenceExpression lhs;
        if (this.reference instanceof PsiPrefixExpression) {
            lhs = (PsiReferenceExpression)((PsiPrefixExpression)this.reference).getOperand();
            sign = ((PsiPrefixExpression)this.reference).getOperationSign();
        } else {
            lhs = (PsiReferenceExpression)((PsiPostfixExpression)this.reference).getOperand();
            sign = ((PsiPostfixExpression)this.reference).getOperationSign();
        }
        PsiElement qualifier = lhs.getQualifier();
        String operator = sign.getText();
        if (qualifier != null) {
            String qualifierText = qualifier.getText();
            String strippedOperator = ReplaceInstanceVariableIncrementDecrement.getStrippedOperator(operator);
            newExpression = qualifierText + '.' + this.delegateName + '.' + this.setterName + '(' + qualifierText + '.' + this.delegateName + '.' + this.getterName + "()" + strippedOperator + "1)";
        } else {
            String strippedOperator = ReplaceInstanceVariableIncrementDecrement.getStrippedOperator(operator);
            newExpression = this.delegateName + '.' + this.setterName + '(' + this.delegateName + '.' + this.getterName + "()" + strippedOperator + "1)";
        }
        MutationUtils.replaceExpression(newExpression, this.reference);
    }

    private static String getStrippedOperator(String operator) {
        return operator.substring(0, operator.length() - 1);
    }
}

