/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceInstanceVariableAssignment
extends FixableUsageInfo {
    private final String setterName;
    private final PsiAssignmentExpression assignment;
    private final String getterName;
    private final String delegateName;

    public ReplaceInstanceVariableAssignment(PsiAssignmentExpression assignment, String delegateName, String setterName, String getterName) {
        super((PsiElement)assignment);
        this.assignment = assignment;
        this.getterName = getterName;
        this.setterName = setterName;
        this.delegateName = delegateName;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression;
        PsiReferenceExpression lhs = (PsiReferenceExpression)this.assignment.getLExpression();
        PsiExpression rhs = this.assignment.getRExpression();
        assert (rhs != null);
        PsiElement qualifier = lhs.getQualifier();
        PsiJavaToken sign = this.assignment.getOperationSign();
        String operator = sign.getText();
        String rhsText = rhs.getText();
        if (qualifier != null) {
            String qualifierText = qualifier.getText();
            if ("=".equals(operator)) {
                newExpression = qualifierText + '.' + this.delegateName + '.' + this.setterName + "( " + rhsText + ')';
            } else {
                String strippedOperator = ReplaceInstanceVariableAssignment.getStrippedOperator(operator);
                newExpression = qualifierText + '.' + this.delegateName + '.' + this.setterName + '(' + qualifierText + '.' + this.delegateName + '.' + this.getterName + "()" + strippedOperator + rhsText + ')';
            }
        } else if ("=".equals(operator)) {
            newExpression = this.delegateName + '.' + this.setterName + "( " + rhsText + ')';
        } else {
            String strippedOperator = ReplaceInstanceVariableAssignment.getStrippedOperator(operator);
            newExpression = this.delegateName + '.' + this.setterName + '(' + this.delegateName + '.' + this.getterName + "()" + strippedOperator + rhsText + ')';
        }
        MutationUtils.replaceExpression(newExpression, (PsiExpression)this.assignment);
    }

    private static String getStrippedOperator(String operator) {
        return operator.substring(0, operator.length() - 1);
    }
}

