/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceInstanceVariableAccess
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String getterName;
    private final String delegateName;

    public ReplaceInstanceVariableAccess(PsiReferenceExpression expression, String delegateName, String getterName) {
        super((PsiElement)expression);
        this.getterName = getterName;
        this.delegateName = delegateName;
        this.expression = expression;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiElement qualifier = this.expression.getQualifier();
        String callString = this.delegateName + '.' + this.getterName + "()";
        if (qualifier != null) {
            String qualifierText = qualifier.getText();
            MutationUtils.replaceExpression(qualifierText + '.' + callString, (PsiExpression)this.expression);
        } else {
            MutationUtils.replaceExpression(callString, (PsiExpression)this.expression);
        }
    }
}

