/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.extractclass.BackpointerUsageVisitor;
import com.intellij.refactoring.extractclass.BackpointerUtil;
import com.intellij.refactoring.extractclass.ExtractClassUsageViewDescriptor;
import com.intellij.refactoring.extractclass.ExtractedClassBuilder;
import com.intellij.refactoring.extractclass.usageInfo.BindJavadocReference;
import com.intellij.refactoring.extractclass.usageInfo.MakeMethodDelegate;
import com.intellij.refactoring.extractclass.usageInfo.RemoveField;
import com.intellij.refactoring.extractclass.usageInfo.RemoveInnerClass;
import com.intellij.refactoring.extractclass.usageInfo.RemoveMethod;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceClassReference;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableAccess;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableAssignment;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableIncrementDecrement;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableAccess;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableAssignment;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableIncrementDecrement;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceThisCallWithDelegateCall;
import com.intellij.refactoring.extractclass.usageInfo.RetargetStaticMethodCall;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.refactoring.psi.TypeParametersVisitor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtractClassProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger logger = Logger.getInstance((String)"com.siyeh.rpp.extractclass.ExtractClassProcessor");
    private final PsiClass sourceClass;
    private final List<PsiField> fields;
    private final List<PsiMethod> methods;
    private final List<PsiClass> innerClasses;
    private final Set<PsiClass> innerClassesToMakePublic = new HashSet<PsiClass>();
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private final String newPackageName;
    private final String myNewVisibility;
    private final boolean myGenerateAccessors;
    private final String newClassName;
    private final String delegateFieldName;
    private final boolean requiresBackpointer;
    private boolean delegationRequired = false;

    public ExtractClassProcessor(PsiClass sourceClass, List<PsiField> fields, List<PsiMethod> methods, List<PsiClass> innerClasses, String newPackageName, String newClassName) {
        this(sourceClass, fields, methods, innerClasses, newPackageName, newClassName, null, false);
    }

    public ExtractClassProcessor(PsiClass sourceClass, List<PsiField> fields, List<PsiMethod> methods, List<PsiClass> classes, String packageName, String newClassName, String newVisibility, boolean generateAccessors) {
        super(sourceClass.getProject());
        this.sourceClass = sourceClass;
        this.newPackageName = packageName;
        this.myNewVisibility = newVisibility;
        this.myGenerateAccessors = generateAccessors;
        this.fields = new ArrayList<PsiField>(fields);
        this.methods = new ArrayList<PsiMethod>(methods);
        this.innerClasses = new ArrayList<PsiClass>(classes);
        this.newClassName = newClassName;
        this.delegateFieldName = this.calculateDelegateFieldName();
        this.requiresBackpointer = new BackpointerUsageVisitor(fields, this.innerClasses, methods, sourceClass).backpointerRequired();
        if (this.requiresBackpointer) {
            this.typeParams.addAll(Arrays.asList(sourceClass.getTypeParameters()));
        } else {
            HashSet<PsiTypeParameter> typeParamSet = new HashSet<PsiTypeParameter>();
            TypeParametersVisitor visitor = new TypeParametersVisitor(typeParamSet);
            for (PsiField field : fields) {
                field.accept((PsiElementVisitor)visitor);
            }
            for (PsiMethod method : methods) {
                method.accept((PsiElementVisitor)visitor);
            }
            this.typeParams.addAll(typeParamSet);
        }
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        Project project = this.sourceClass.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)project).findClass(StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName), scope);
        if (existingClass != null) {
            conflicts.putValue((Object)existingClass, (Object)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("there.already.exists.a.class.with.the.chosen.name", new Object[0])));
        }
        if (!this.myGenerateAccessors) {
            this.calculateInitializersConflicts((MultiMap<PsiElement, String>)conflicts);
            NecessaryAccessorsVisitor visitor = new NecessaryAccessorsVisitor();
            for (PsiField field : this.fields) {
                field.accept((PsiElementVisitor)visitor);
            }
            for (PsiMethod method : this.methods) {
                method.accept((PsiElementVisitor)visitor);
            }
            for (PsiClass innerClass : this.innerClasses) {
                innerClass.accept((PsiElementVisitor)visitor);
            }
            Set<PsiField> fieldsNeedingGetter = visitor.getFieldsNeedingGetter();
            for (PsiField field : fieldsNeedingGetter) {
                conflicts.putValue((Object)field, (Object)("Field '" + field.getName() + "' needs getter"));
            }
            Set<PsiField> fieldsNeedingSetter = visitor.getFieldsNeedingSetter();
            for (PsiField field : fieldsNeedingSetter) {
                conflicts.putValue((Object)field, (Object)("Field '" + field.getName() + "' needs getter"));
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private void calculateInitializersConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiClassInitializer[] initializers;
        for (PsiClassInitializer psiClassInitializer : initializers = this.sourceClass.getInitializers()) {
            if (!this.initializerDependsOnMoved((PsiElement)psiClassInitializer)) continue;
            conflicts.putValue((Object)psiClassInitializer, (Object)"Class initializer requires moved members");
        }
        for (PsiClassInitializer psiClassInitializer : this.sourceClass.getConstructors()) {
            if (!this.initializerDependsOnMoved((PsiElement)psiClassInitializer.getBody())) continue;
            conflicts.putValue((Object)psiClassInitializer, (Object)"Constructor requires moved members");
        }
    }

    private boolean initializerDependsOnMoved(PsiElement initializer) {
        final boolean[] dependsOnMoved = new boolean[]{false};
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved != null) {
                    dependsOnMoved[0] = dependsOnMoved[0] | ExtractClassProcessor.this.isInMovedElement(resolved);
                }
            }
        });
        return dependsOnMoved[0];
    }

    private String calculateDelegateFieldName() {
        Project project = this.sourceClass.getProject();
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        CodeStyleSettings settings = settingsManager.getCurrentSettings();
        String baseName = settings.FIELD_NAME_PREFIX.length() == 0 ? StringUtil.decapitalize((String)this.newClassName) : this.newClassName;
        String name = settings.FIELD_NAME_PREFIX + baseName + settings.FIELD_NAME_SUFFIX;
        if (!this.existsFieldWithName(name) && !JavaPsiFacade.getInstance((Project)project).getNameHelper().isKeyword(name)) {
            return name;
        }
        int counter = 1;
        while (this.existsFieldWithName(name = settings.FIELD_NAME_PREFIX + baseName + counter + settings.FIELD_NAME_SUFFIX) || JavaPsiFacade.getInstance((Project)project).getNameHelper().isKeyword(name)) {
            ++counter;
        }
        return name;
    }

    private boolean existsFieldWithName(String name) {
        PsiField[] allFields;
        for (PsiField field : allFields = this.sourceClass.getAllFields()) {
            if (!name.equals(field.getName()) || this.fields.contains(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return RefactorJBundle.message("extracted.class.command.name", this.newClassName);
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usageInfos) {
        return new ExtractClassUsageViewDescriptor(this.sourceClass);
    }

    @Override
    protected void performRefactoring(UsageInfo[] usageInfos) {
        PsiMethod member;
        PsiClass psiClass = this.buildClass();
        if (psiClass == null) {
            return;
        }
        if (this.delegationRequired) {
            this.buildDelegate();
        }
        final HashSet<PsiMethod> members = new HashSet<PsiMethod>();
        for (PsiMethod psiMethod : this.methods) {
            member = psiClass.findMethodBySignature(psiMethod, false);
            if (member == null) continue;
            members.add(member);
        }
        for (PsiField psiField : this.fields) {
            PsiMethod constructor;
            member = psiClass.findFieldByName(psiField.getName(), false);
            if (member == null) continue;
            members.add(member);
            PsiExpression initializer = member.getInitializer();
            if (initializer == null) continue;
            final boolean[] moveInitializerToConstructor = new boolean[1];
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    PsiElement resolved = expression.resolve();
                    if (resolved instanceof PsiField && !members.contains(resolved)) {
                        moveInitializerToConstructor[0] = true;
                    }
                }
            });
            if (!moveInitializerToConstructor[0]) continue;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            PsiMethod[] constructors = psiClass.getConstructors();
            if (constructors.length == 0) {
                constructor = elementFactory.createConstructor();
                constructor.setName(psiClass.getName());
                constructor = (PsiMethod)psiClass.add((PsiElement)constructor);
            } else {
                constructor = constructors[0];
            }
            MoveInstanceMembersUtil.moveInitializerToConstructor(elementFactory, constructor, (PsiField)member);
        }
        if (this.myGenerateAccessors) {
            NecessaryAccessorsVisitor visitor = new NecessaryAccessorsVisitor();
            for (PsiField field : this.fields) {
                field.accept((PsiElementVisitor)visitor);
            }
            for (PsiMethod method : this.methods) {
                method.accept((PsiElementVisitor)visitor);
            }
            for (PsiClass innerClass : this.innerClasses) {
                innerClass.accept((PsiElementVisitor)visitor);
            }
            for (PsiField field : visitor.getFieldsNeedingGetter()) {
                this.sourceClass.add((PsiElement)PropertyUtil.generateGetterPrototype((PsiField)field));
            }
            for (PsiField field : visitor.getFieldsNeedingSetter()) {
                this.sourceClass.add((PsiElement)PropertyUtil.generateSetterPrototype((PsiField)field));
            }
        }
        super.performRefactoring(usageInfos);
        if (this.myNewVisibility == null) {
            return;
        }
        for (PsiMember psiMember : members) {
            VisibilityUtil.fixVisibility((UsageInfo[])usageInfos, (PsiMember)psiMember, (String)this.myNewVisibility);
        }
    }

    private void buildDelegate() {
        PsiManager manager = this.sourceClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        StringBuilder fieldBuffer = new StringBuilder();
        String delegateVisibility = this.calculateDelegateVisibility();
        fieldBuffer.append(delegateVisibility).append(' ');
        fieldBuffer.append("final ");
        String fullyQualifiedName = StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName);
        fieldBuffer.append(fullyQualifiedName);
        if (!this.typeParams.isEmpty()) {
            fieldBuffer.append('<');
            for (PsiTypeParameter typeParameter : this.typeParams) {
                fieldBuffer.append(typeParameter.getName());
            }
            fieldBuffer.append('>');
        }
        fieldBuffer.append(' ');
        fieldBuffer.append(this.delegateFieldName);
        fieldBuffer.append('=');
        fieldBuffer.append("new ").append(fullyQualifiedName);
        if (!this.typeParams.isEmpty()) {
            fieldBuffer.append('<');
            for (PsiTypeParameter typeParameter : this.typeParams) {
                fieldBuffer.append(typeParameter.getName());
            }
            fieldBuffer.append('>');
        }
        fieldBuffer.append('(');
        boolean isFirst = true;
        if (this.requiresBackpointer) {
            fieldBuffer.append("this");
            isFirst = false;
        }
        for (PsiField field : this.fields) {
            PsiExpression initializer;
            if (field.hasModifierProperty("static") || !field.hasInitializer() || PsiUtil.isConstantExpression((PsiExpression)(initializer = field.getInitializer()))) continue;
            if (!isFirst) {
                fieldBuffer.append(", ");
            }
            isFirst = false;
            assert (initializer != null);
            fieldBuffer.append(initializer.getText());
        }
        fieldBuffer.append(");");
        try {
            PsiField field;
            String fieldString = fieldBuffer.toString();
            field = factory.createFieldFromText(fieldString, (PsiElement)this.sourceClass);
            PsiElement newField = this.sourceClass.add((PsiElement)field);
            codeStyleManager.reformat(JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(newField));
        }
        catch (IncorrectOperationException e) {
            logger.error((Throwable)e);
        }
    }

    @NonNls
    private String calculateDelegateVisibility() {
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("public") || field.hasModifierProperty("static")) continue;
            return "public";
        }
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("protected") || field.hasModifierProperty("static")) continue;
            return "protected";
        }
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("packageLocal") || field.hasModifierProperty("static")) continue;
            return "";
        }
        return "private";
    }

    @Override
    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractclass/ExtractClassProcessor.findUsages must not be null");
        }
        for (PsiField field : this.fields) {
            this.findUsagesForField(field, usages);
            usages.add(new RemoveField(field));
        }
        for (PsiClass innerClass : this.innerClasses) {
            this.findUsagesForInnerClass(innerClass, usages);
            usages.add(new RemoveInnerClass(innerClass));
        }
        for (PsiMethod method : this.methods) {
            if (method.hasModifierProperty("static")) {
                this.findUsagesForStaticMethod(method, usages);
                continue;
            }
            this.findUsagesForMethod(method, usages);
        }
    }

    private void findUsagesForInnerClass(PsiClass innerClass, List<FixableUsageInfo> usages) {
        PsiManager psiManager = innerClass.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)innerClass, (SearchScope)scope);
        String innerName = innerClass.getQualifiedName();
        assert (innerName != null);
        String sourceClassQualifiedName = this.sourceClass.getQualifiedName();
        assert (sourceClassQualifiedName != null);
        String newInnerClassName = StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName) + innerName.substring(sourceClassQualifiedName.length());
        boolean hasExternalReference = false;
        for (PsiReference reference : calls) {
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiJavaCodeReferenceElement) || this.isInMovedElement(referenceElement)) continue;
            usages.add(new ReplaceClassReference((PsiJavaCodeReferenceElement)referenceElement, newInnerClassName));
            hasExternalReference = true;
        }
        if (hasExternalReference) {
            this.innerClassesToMakePublic.add(innerClass);
        }
    }

    private void findUsagesForMethod(PsiMethod method, List<FixableUsageInfo> usages) {
        PsiManager psiManager = method.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
        for (PsiReference reference : calls) {
            PsiMethodCallExpression call;
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (!(parent instanceof PsiMethodCallExpression) || this.isInMovedElement((PsiElement)(call = (PsiMethodCallExpression)parent))) continue;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                usages.add(new ReplaceThisCallWithDelegateCall(call, this.delegateFieldName));
            }
            this.delegationRequired = true;
        }
        if (!this.delegationRequired && MethodInheritanceUtils.hasSiblingMethods(method)) {
            this.delegationRequired = true;
        }
        if (this.delegationRequired) {
            usages.add(new MakeMethodDelegate(method, this.delegateFieldName));
        } else {
            usages.add(new RemoveMethod(method));
        }
    }

    private void findUsagesForStaticMethod(PsiMethod method, List<FixableUsageInfo> usages) {
        PsiManager psiManager = method.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
        for (PsiReference reference : calls) {
            PsiMethodCallExpression call;
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (!(parent instanceof PsiMethodCallExpression) || this.isInMovedElement((PsiElement)(call = (PsiMethodCallExpression)parent))) continue;
            String fullyQualifiedName = StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName);
            usages.add(new RetargetStaticMethodCall(call, fullyQualifiedName));
        }
        usages.add(new RemoveMethod(method));
    }

    private boolean isInMovedElement(PsiElement exp) {
        for (PsiField field : this.fields) {
            if (!PsiTreeUtil.isAncestor((PsiElement)field, (PsiElement)exp, (boolean)false)) continue;
            return true;
        }
        for (PsiMethod method : this.methods) {
            if (!PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)exp, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void findUsagesForField(PsiField field, List<FixableUsageInfo> usages) {
        PsiManager psiManager = field.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        String qualifiedName = StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName);
        String getter = PropertyUtil.suggestGetterName((Project)this.myProject, (PsiField)field);
        String setter = PropertyUtil.suggestSetterName((Project)this.myProject, (PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)scope)) {
            PsiElement element = reference.getElement();
            if (this.isInMovedElement(element)) continue;
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression exp = (PsiReferenceExpression)element;
                if (RefactoringUtil.isPlusPlusOrMinusMinus(exp.getParent())) {
                    usages.add(isStatic ? new ReplaceStaticVariableIncrementDecrement((PsiExpression)exp, qualifiedName) : new ReplaceInstanceVariableIncrementDecrement((PsiExpression)exp, this.delegateFieldName, setter, getter));
                } else if (RefactoringUtil.isAssignmentLHS((PsiElement)exp)) {
                    usages.add(isStatic ? new ReplaceStaticVariableAssignment(exp, qualifiedName) : new ReplaceInstanceVariableAssignment((PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)exp, PsiAssignmentExpression.class), this.delegateFieldName, setter, getter));
                } else {
                    usages.add(isStatic ? new ReplaceStaticVariableAccess(exp, qualifiedName) : new ReplaceInstanceVariableAccess(exp, this.delegateFieldName, getter));
                }
                if (isStatic) continue;
                this.delegationRequired = true;
                continue;
            }
            if (!(element instanceof PsiDocTagValue)) continue;
            usages.add(new BindJavadocReference(element, qualifiedName, field.getName()));
        }
    }

    private boolean hasGetter(PsiField field) {
        return this.hasGetterOrSetter(this.sourceClass.findMethodsBySignature(PropertyUtil.generateGetterPrototype((PsiField)field), false));
    }

    private boolean hasSetter(PsiField field) {
        return this.hasGetterOrSetter(this.sourceClass.findMethodsBySignature(PropertyUtil.generateSetterPrototype((PsiField)field), false));
    }

    private boolean hasGetterOrSetter(PsiMethod[] getters) {
        for (PsiMethod getter : getters) {
            if (this.isInMovedElement((PsiElement)getter)) continue;
            return true;
        }
        return false;
    }

    private PsiClass buildClass() {
        PsiManager manager = this.sourceClass.getManager();
        Project project = this.sourceClass.getProject();
        ExtractedClassBuilder extractedClassBuilder = new ExtractedClassBuilder();
        extractedClassBuilder.setProject(this.myProject);
        extractedClassBuilder.setClassName(this.newClassName);
        extractedClassBuilder.setPackageName(this.newPackageName);
        extractedClassBuilder.setOriginalClassName(this.sourceClass.getQualifiedName());
        extractedClassBuilder.setRequiresBackPointer(this.requiresBackpointer);
        for (PsiField field : this.fields) {
            extractedClassBuilder.addField(field);
        }
        for (PsiMethod method : this.methods) {
            extractedClassBuilder.addMethod(method);
        }
        for (PsiClass innerClass : this.innerClasses) {
            extractedClassBuilder.addInnerClass(innerClass, this.innerClassesToMakePublic.contains(innerClass));
        }
        extractedClassBuilder.setTypeArguments(this.typeParams);
        List<PsiClass> interfaces = this.calculateInterfacesSupported();
        extractedClassBuilder.setInterfaces(interfaces);
        if (this.myGenerateAccessors) {
            NecessaryAccessorsVisitor visitor = new NecessaryAccessorsVisitor(){

                @Override
                protected boolean isProhibitedReference(PsiField field) {
                    if (ExtractClassProcessor.this.fields.contains(field)) {
                        return true;
                    }
                    return ExtractClassProcessor.this.innerClasses.contains(field.getContainingClass());
                }
            };
            this.sourceClass.accept((PsiElementVisitor)visitor);
            extractedClassBuilder.setFieldsNeedingGetters(visitor.getFieldsNeedingGetter());
            extractedClassBuilder.setFieldsNeedingSetters(visitor.getFieldsNeedingSetter());
        }
        String classString = extractedClassBuilder.buildBeanClass();
        try {
            PsiFile containingFile = this.sourceClass.getContainingFile();
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)containingFile);
            assert (module != null);
            PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.newPackageName, containingDirectory, false);
            if (directory != null) {
                PsiFile newFile = PsiFileFactory.getInstance((Project)project).createFileFromText(this.newClassName + ".java", classString);
                PsiElement addedFile = directory.add((PsiElement)newFile);
                CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
                PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedFile);
                return ((PsiJavaFile)codeStyleManager.reformat(shortenedFile)).getClasses()[0];
            }
            return null;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private List<PsiClass> calculateInterfacesSupported() {
        PsiClass[] supers;
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        for (PsiClass superClass : supers = this.sourceClass.getSupers()) {
            PsiMethod[] superclassMethods;
            if (!superClass.isInterface() || (superclassMethods = superClass.getMethods()).length == 0) continue;
            boolean allMethodsCovered = true;
            for (PsiMethod method : superclassMethods) {
                boolean isCovered = false;
                for (PsiMethod movedMethod : this.methods) {
                    if (!ExtractClassProcessor.isSuperMethod(method, movedMethod)) continue;
                    isCovered = true;
                    break;
                }
                if (isCovered) continue;
                allMethodsCovered = false;
                break;
            }
            if (!allMethodsCovered) continue;
            out.add(superClass);
        }
        Project project = this.sourceClass.getProject();
        PsiManager manager = this.sourceClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        if (ExtractClassProcessor.usesDefaultSerialization(this.sourceClass)) {
            PsiClass serializable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Serializable", scope);
            out.add(serializable);
        }
        if (ExtractClassProcessor.usesDefaultClone(this.sourceClass)) {
            PsiClass cloneable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Cloneable", scope);
            out.add(cloneable);
        }
        return out;
    }

    private static boolean isSuperMethod(PsiMethod method, PsiMethod movedMethod) {
        PsiMethod[] superMethods;
        for (PsiMethod testMethod : superMethods = movedMethod.findSuperMethods()) {
            if (!testMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean usesDefaultClone(PsiClass aClass) {
        PsiMethod[] methods;
        Project project = aClass.getProject();
        PsiManager manager = aClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass cloneable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Cloneable", scope);
        if (!InheritanceUtil.isCorrectDescendant((PsiClass)aClass, (PsiClass)cloneable, (boolean)true)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("clone", false)) {
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 0) continue;
            return false;
        }
        return true;
    }

    private static boolean usesDefaultSerialization(PsiClass aClass) {
        PsiMethod[] methods;
        Project project = aClass.getProject();
        PsiManager manager = aClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass serializable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Serializable", scope);
        if (!InheritanceUtil.isCorrectDescendant((PsiClass)aClass, (PsiClass)serializable, (boolean)true)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            PsiType type;
            String text;
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 1 || !"java.io.DataOutputStream".equals(text = (type = parameters[0].getType()).getCanonicalText())) continue;
            return false;
        }
        return true;
    }

    private class NecessaryAccessorsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> fieldsNeedingGetter = new HashSet<PsiField>();
        private final Set<PsiField> fieldsNeedingSetter = new HashSet<PsiField>();

        private NecessaryAccessorsVisitor() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiField field;
            super.visitReferenceExpression(expression);
            if (this.isProhibitedReference((PsiExpression)expression) && !ExtractClassProcessor.this.hasGetter(field = this.getReferencedField((PsiExpression)expression)) && !this.isStaticFinal(field)) {
                this.fieldsNeedingGetter.add(field);
            }
        }

        private boolean isStaticFinal(PsiField field) {
            PsiModifierList modifierList = field.getModifierList();
            logger.assertTrue(modifierList != null);
            return modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiField field;
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            if (this.isProhibitedReference(lhs) && !ExtractClassProcessor.this.hasGetter(field = this.getReferencedField(lhs)) && !this.isStaticFinal(field)) {
                this.fieldsNeedingSetter.add(field);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            this.checkSetterNeeded(expression.getOperand(), expression.getOperationSign());
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            this.checkSetterNeeded(expression.getOperand(), expression.getOperationSign());
        }

        private void checkSetterNeeded(PsiExpression operand, PsiJavaToken sign) {
            PsiField field;
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            if (this.isProhibitedReference(operand) && !ExtractClassProcessor.this.hasSetter(field = this.getReferencedField(operand)) && !this.isStaticFinal(field)) {
                this.fieldsNeedingSetter.add(field);
            }
        }

        public Set<PsiField> getFieldsNeedingGetter() {
            return this.fieldsNeedingGetter;
        }

        public Set<PsiField> getFieldsNeedingSetter() {
            return this.fieldsNeedingSetter;
        }

        protected boolean isProhibitedReference(PsiExpression expression) {
            return BackpointerUtil.isBackpointerReference(expression, new Condition<PsiField>(){

                public boolean value(PsiField field) {
                    return NecessaryAccessorsVisitor.this.isProhibitedReference(field);
                }
            });
        }

        protected boolean isProhibitedReference(PsiField field) {
            if (ExtractClassProcessor.this.fields.contains(field)) {
                return false;
            }
            return !ExtractClassProcessor.this.innerClasses.contains(field.getContainingClass());
        }

        private PsiField getReferencedField(PsiExpression expression) {
            if (expression instanceof PsiParenthesizedExpression) {
                PsiExpression contents = ((PsiParenthesizedExpression)expression).getExpression();
                return this.getReferencedField(contents);
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            return (PsiField)reference.resolve();
        }
    }
}

