/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectHandler.class.getName()));

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler.invoke must not be null");
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.this.invokeOnElements(project, editor, file, selectedValue);
            }
        });
    }

    private void invokeOnElements(final Project project, final Editor editor, PsiFile file, PsiElement[] elements) {
        if (elements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        final ExtractMethodObjectProcessor processor = new ExtractMethodObjectProcessor(project, editor, elements, "");
        final ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor.getExtractProcessor();
        try {
            if (!extractProcessor.prepare()) {
                return;
            }
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            new WriteCommandAction(project, "Extract Method Object", "Extract Method Object", new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    extractProcessor.doRefactoring();
                    processor.run();
                    if (processor.isCreateInnerClass()) {
                        processor.moveUsedMethodsToInner();
                        DuplicatesImpl.processDuplicates(extractProcessor, project, editor);
                        processor.changeInstanceAccess(project);
                    }
                    PsiMethod method = processor.getMethod();
                    LOG.assertTrue(method != null);
                    method.delete();
                }
            }.execute();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler.invoke must not be null");
        }
        throw new UnsupportedOperationException();
    }
}

