/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

class TypeParameterInfo {
    private final int myOldParameterIndex;
    private String myNewName;
    private CanonicalTypes.Type myDefaultValue;

    TypeParameterInfo(int oldIndex) {
        this.myOldParameterIndex = oldIndex;
        this.myDefaultValue = null;
    }

    TypeParameterInfo(String name, PsiType aType) {
        this.myOldParameterIndex = -1;
        this.myNewName = name;
        this.myDefaultValue = aType != null ? CanonicalTypes.createTypeWrapper(aType) : null;
    }

    TypeParameterInfo(PsiClass aClass, @NonNls String name, @NonNls String defaultValue) throws IncorrectOperationException {
        this(name, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createTypeFromText(defaultValue, (PsiElement)aClass.getLBrace()));
    }

    public int getOldParameterIndex() {
        return this.myOldParameterIndex;
    }

    public String getNewName() {
        return this.myNewName;
    }

    public void setNewName(String newName) {
        this.myNewName = newName;
    }

    public CanonicalTypes.Type getDefaultValue() {
        return this.myDefaultValue;
    }

    public void setDefaultValue(CanonicalTypes.Type defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setDefaultValue(PsiType aType) {
        this.setDefaultValue(CanonicalTypes.createTypeWrapper(aType));
    }

    boolean isForExistingParameter() {
        return this.myOldParameterIndex >= 0;
    }
}

