/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditableRowTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RowEditableTableModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChangeClassSignatureDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog");
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private final List<TypeParameterInfo> myTypeParameterInfos;
    private final List<PsiTypeCodeFragment> myTypeCodeFragments;
    private final PsiClass myClass;
    private final PsiTypeParameter[] myOriginalParameters;
    private final PsiManager myManager;
    private final MyTableModel myTableModel;
    private Table myTable;
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeClassSignature.refactoring.name");

    public ChangeClassSignatureDialog(PsiClass aClass) {
        super(aClass.getProject(), true);
        this.setTitle(REFACTORING_NAME);
        this.myClass = aClass;
        this.myManager = this.myClass.getManager();
        this.myTypeParameterInfos = new ArrayList<TypeParameterInfo>();
        this.myTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>();
        this.myOriginalParameters = this.myClass.getTypeParameters();
        for (int i = 0; i < this.myOriginalParameters.length; ++i) {
            this.myTypeParameterInfos.add(new TypeParameterInfo(i));
            this.myTypeCodeFragments.add(null);
        }
        this.myTableModel = new MyTableModel();
        this.init();
    }

    private PsiTypeCodeFragment createValueCodeFragment() {
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createTypeCodeFragment("", (PsiElement)this.myClass.getLBrace(), false, true, false);
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel(RefactoringBundle.message((String)"changeClassSignature.class.label.text", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.myClass)}));
        box.add(label);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.changeClassSignature");
    }

    protected JComponent createCenterPanel() {
        this.myTable = new Table((TableModel)this.myTableModel);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        TableColumn valueColumn = this.myTable.getColumnModel().getColumn(1);
        Project project = this.myClass.getProject();
        nameColumn.setCellRenderer((TableCellRenderer)((Object)new MyCellRenderer()));
        nameColumn.setCellEditor(new StringTableCellEditor(project));
        valueColumn.setCellRenderer(new MyCodeFragmentTableCellRenderer());
        valueColumn.setCellEditor(new CodeFragmentTableCellEditor(project));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(210, this.myTable.getRowHeight() * 4));
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.setFocusCycleRoot(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"changeClassSignature.parameters.panel.border.title")));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        panel.add((Component)scrollPane, "Center");
        JPanel buttonsTable = EditableRowTable.createButtonsTable((JTable)this.myTable, (RowEditableTableModel)this.myTableModel, (boolean)true);
        panel.add((Component)buttonsTable, "East");
        return panel;
    }

    @Override
    protected void doAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        String message = this.validateAndCommitData();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.incorrect.data"), (String)message, (String)"refactoring.changeSignature", (Project)this.myClass.getProject());
            return;
        }
        ChangeClassSignatureProcessor processor = new ChangeClassSignatureProcessor(this.myClass.getProject(), this.myClass, this.myTypeParameterInfos.toArray(new TypeParameterInfo[this.myTypeParameterInfos.size()]));
        this.invokeRefactoring(processor);
    }

    private String validateAndCommitData() {
        for (TypeParameterInfo info : this.myTypeParameterInfos) {
            if (info.isForExistingParameter() || JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getNameHelper().isIdentifier(info.getNewName())) continue;
            return RefactoringBundle.message((String)"error.wrong.name.input", (Object[])new Object[]{info.getNewName()});
        }
        LOG.assertTrue(this.myTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        for (int i = 0; i < this.myTypeCodeFragments.size(); ++i) {
            PsiType type;
            PsiTypeCodeFragment codeFragment = this.myTypeCodeFragments.get(i);
            TypeParameterInfo info = this.myTypeParameterInfos.get(i);
            if (info.getOldParameterIndex() >= 0) continue;
            try {
                type = codeFragment.getType();
                if (type instanceof PsiPrimitiveType) {
                    return "Type parameter can't be primitive";
                }
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeClassSignature.bad.default.value", (Object[])new Object[]{codeFragment.getText(), info.getNewName()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{info.getNewName()});
            }
            info.setDefaultValue(type);
        }
        return null;
    }

    private class MyCodeFragmentTableCellRenderer
    extends CodeFragmentTableCellRenderer {
        public MyCodeFragmentTableCellRenderer() {
            super(ChangeClassSignatureDialog.this.getProject());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!ChangeClassSignatureDialog.this.myTableModel.isCellEditable(row, column)) {
                component.setBackground(component.getBackground().darker());
            }
            return component;
        }
    }

    private class MyCellRenderer
    extends ColoredTableCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!ChangeClassSignatureDialog.this.myTableModel.isCellEditable(row, column)) {
                this.setBackground(this.getBackground().darker());
            }
            this.append((String)value, new SimpleTextAttributes(0, null));
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements RowEditableTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.size();
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    TypeParameterInfo info = (TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex);
                    if (info.isForExistingParameter()) {
                        return ChangeClassSignatureDialog.this.myOriginalParameters[info.getOldParameterIndex()].getName();
                    }
                    return info.getNewName();
                }
                case 1: {
                    return ChangeClassSignatureDialog.this.myTypeCodeFragments.get(rowIndex);
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).isForExistingParameter();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return RefactoringBundle.message((String)"column.name.name");
                }
                case 1: {
                    return RefactoringBundle.message((String)"changeSignature.default.value.column");
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).setNewName((String)aValue);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
        }

        public void addRow() {
            TableUtil.stopEditing((JTable)ChangeClassSignatureDialog.this.myTable);
            ChangeClassSignatureDialog.this.myTypeParameterInfos.add(new TypeParameterInfo("", null));
            ChangeClassSignatureDialog.this.myTypeCodeFragments.add(ChangeClassSignatureDialog.this.createValueCodeFragment());
            this.fireTableDataChanged();
        }

        public void removeRow(int index) {
            ChangeClassSignatureDialog.this.myTypeParameterInfos.remove(index);
            ChangeClassSignatureDialog.this.myTypeCodeFragments.remove(index);
            this.fireTableDataChanged();
        }

        public void exchangeRows(int index1, int index2) {
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeParameterInfos, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeCodeFragments, (int)index1, (int)index2);
            this.fireTableDataChanged();
        }
    }
}

