/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;

public class SafeDeleteAction
extends BaseRefactoringAction {
    public SafeDeleteAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        for (PsiElement element : elements) {
            if (SafeDeleteProcessor.validElement(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        return SafeDeleteProcessor.validElement(element);
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return new SafeDeleteHandler();
    }
}

