/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler;

public class EncapsulateFieldsAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof PsiClass || EncapsulateFieldsAction.isAcceptedField(elements[0]);
        }
        if (elements.length > 1) {
            for (int idx = 0; idx < elements.length; ++idx) {
                if (EncapsulateFieldsAction.isAcceptedField(elements[idx])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return new EncapsulateFieldsHandler();
    }

    private static boolean isAcceptedField(PsiElement element) {
        return element instanceof PsiField && ((PsiField)element).getContainingClass() != null;
    }
}

