/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.Set;

public class OptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<PsiJavaFile>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.OptimizeImportsRefactoringHelper");

    @Override
    public Set<PsiJavaFile> prepareOperation(UsageInfo[] usages) {
        HashSet javaFiles = new HashSet();
        for (UsageInfo usage : usages) {
            PsiFile file;
            PsiElement element = usage.getElement();
            if (element == null || !((file = element.getContainingFile()) instanceof PsiJavaFile)) continue;
            javaFiles.add((PsiJavaFile)file);
        }
        return javaFiles;
    }

    @Override
    public void performOperation(Project project, Set<PsiJavaFile> javaFiles) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (PsiJavaFile file : javaFiles) {
            try {
                if (!file.isValid() || file.getVirtualFile() == null) continue;
                styleManager.removeRedundantImports(file);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

