/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.BaseRefactoringProcessor");
    public static final Runnable EMPTY_CALLBACK = EmptyRunnable.getInstance();
    protected final Project myProject;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback = EMPTY_CALLBACK;

    protected BaseRefactoringProcessor(Project project) {
        this(project, null);
    }

    protected BaseRefactoringProcessor(Project project, @Nullable Runnable prepareSuccessfulCallback) {
        this.myProject = project;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
    }

    protected abstract UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] var1);

    @NotNull
    protected abstract UsageInfo[] findUsages();

    protected abstract void refreshElements(PsiElement[] var1);

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(UsageInfo[] usages) {
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(UsageInfo[] var1);

    protected abstract String getCommandName();

    protected void doRun() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final Ref refUsages = new Ref();
        final Ref refErrorLanguage = new Ref();
        final Ref refProcessCanceled = new Ref();
        final Ref dumbModeOccured = new Ref();
        Runnable findUsagesRunnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            refUsages.set((Object)BaseRefactoringProcessor.this.findUsages());
                        }
                        catch (UnknownReferenceTypeException e) {
                            refErrorLanguage.set((Object)e.getElementLanguage());
                        }
                        catch (ProcessCanceledException e) {
                            refProcessCanceled.set((Object)Boolean.TRUE);
                        }
                        catch (IndexNotReadyException e) {
                            dumbModeOccured.set((Object)Boolean.TRUE);
                        }
                    }
                });
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message((String)"progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"unsupported.refs.found", (Object[])new Object[]{((Language)refErrorLanguage.get()).getDisplayName()}), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!dumbModeOccured.isNull()) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Usage search is not available until indices are ready");
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)"Index corruption detected. Please retry the refactoring - indexes will be rebuilt automatically", (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor = this.createUsageViewDescriptor(usages);
        boolean isPreview = this.isPreviewUsages(usages);
        if (!isPreview) {
            boolean bl = isPreview = !this.ensureElementsWritable(usages, descriptor) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"readonly.occurences.found"));
            }
        }
        if (isPreview) {
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    protected void previewRefactoring(UsageInfo[] usages) {
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(elements);
        Factory<UsageSearcher> factory = new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageSearcher(){

                    public void generate(Processor<Usage> processor) {
                        UsageInfo2UsageAdapter[] usages;
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < elements.length; ++i) {
                                    elements[i] = targets[i].getElement();
                                }
                                BaseRefactoringProcessor.this.refreshElements(elements);
                            }
                        });
                        final Ref refUsages = new Ref();
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                refUsages.set((Object)BaseRefactoringProcessor.this.findUsages());
                            }
                        });
                        for (UsageInfo2UsageAdapter usage : usages = UsageInfo2UsageAdapter.convert((UsageInfo[])((UsageInfo[])refUsages.get()))) {
                            processor.process((Object)usage);
                        }
                    }
                };
            }
        };
        this.showUsageView(viewDescriptor, factory, usages);
    }

    private boolean ensureElementsWritable(@NotNull UsageInfo[] usages, UsageViewDescriptor descriptor) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/BaseRefactoringProcessor.ensureElementsWritable must not be null");
        }
        THashSet elements = new THashSet();
        for (UsageInfo usage : usages) {
            assert (usage != null) : "Found null element in usages array";
            PsiElement element = usage.getElement();
            if (element == null) continue;
            elements.add(element);
        }
        elements.addAll(this.getElementsToWrite(descriptor));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements);
    }

    private static boolean ensureFilesWritable(Project project, Collection<? extends PsiElement> elements) {
        PsiElement[] psiElements = elements.toArray(new PsiElement[elements.size()]);
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement[])psiElements);
    }

    void execute(final UsageInfo[] usages) {
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        HashSet usageInfos = new HashSet(Arrays.asList(usages));
                        BaseRefactoringProcessor.this.doRefactoring((Collection)usageInfos);
                        if (BaseRefactoringProcessor.this.isGlobalUndoAction()) {
                            CommandProcessor.getInstance().markCurrentCommandAsGlobal(BaseRefactoringProcessor.this.myProject);
                        }
                    }
                });
            }
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DEFAULT;
    }

    private static UsageViewPresentation createPresentation(UsageViewDescriptor descriptor, Usage[] usages) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation.setTargetsNodeText(descriptor.getProcessedElementsHeader());
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        HashSet codeFiles = new HashSet();
        HashSet nonCodeFiles = new HashSet();
        for (Usage usage : usages) {
            if (!(usage instanceof PsiElementUsage)) continue;
            PsiElementUsage elementUsage = (PsiElementUsage)usage;
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(elementUsage.getElement().getContainingFile());
                continue;
            }
            ++codeUsageCount;
            codeFiles.add(elementUsage.getElement().getContainingFile());
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        presentation.setCodeUsagesString(descriptor.getCodeReferencesText(codeUsageCount, codeFiles.size()));
        presentation.setNonCodeUsagesString(descriptor.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size()));
        return presentation;
    }

    private void showUsageView(final UsageViewDescriptor viewDescriptor, Factory<UsageSearcher> factory, UsageInfo[] usageInfos) {
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(initialElements);
        UsageInfo2UsageAdapter[] usages = UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos);
        UsageViewPresentation presentation = BaseRefactoringProcessor.createPresentation(viewDescriptor, (Usage[])usages);
        final UsageView usageView = viewManager.showUsages((UsageTarget[])targets, (Usage[])usages, presentation, factory);
        Runnable refactoringRunnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Set usagesToRefactor = BaseRefactoringProcessor.getUsageInfosToRefactor(usageView);
                        if (BaseRefactoringProcessor.this.ensureElementsWritable(usagesToRefactor.toArray(new UsageInfo[usagesToRefactor.size()]), viewDescriptor)) {
                            BaseRefactoringProcessor.this.doRefactoring(usagesToRefactor);
                        }
                    }
                });
            }
        };
        String canNotMakeString = RefactoringBundle.message((String)"usageView.need.reRun");
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message((String)"usageView.doAction"));
    }

    private static Set<UsageInfo> getUsageInfosToRefactor(UsageView usageView) {
        Set excludedUsages = usageView.getExcludedUsages();
        HashSet usageInfos = new HashSet();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        return usageInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        if (usageInfoSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/BaseRefactoringProcessor.doRefactoring must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Iterator<UsageInfo> iterator = usageInfoSet.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            PsiElement element = usageInfo.getElement();
            if (element != null && element.isWritable()) continue;
            iterator.remove();
        }
        LocalHistoryAction action = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName());
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(new UsageInfo[usageInfoSet.size()]);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            HashMap preparedData = new HashMap();
            for (RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
                preparedData.put(helper, helper.prepareOperation(writableUsageInfos));
            }
            this.performRefactoring(writableUsageInfos);
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            this.performPsiSpoilingRefactoring();
        }
        finally {
            action.finish();
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"statusBar.refactoring.result", (Object[])new Object[]{count}));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"statusBar.noUsages"));
        }
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void prepareTestRun() {
    }

    public final void run() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.testRun();
        } else {
            this.doRun();
        }
    }

    private void testRun() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.prepareTestRun();
        Ref refUsages = new Ref((Object)this.findUsages());
        this.preprocessUsages((Ref<UsageInfo[]>)refUsages);
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        UsageViewDescriptor descriptor = this.createUsageViewDescriptor(usages);
        if (!this.ensureElementsWritable(usages, descriptor)) {
            return;
        }
        RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
        this.myTransaction = listenerManager.startTransaction();
        HashMap preparedData = new HashMap();
        for (RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
            preparedData.put(helper, helper.prepareOperation(usages));
        }
        this.performRefactoring(usages);
        for (Map.Entry e : preparedData.entrySet()) {
            ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
        }
        this.myTransaction.commit();
        this.performPsiSpoilingRefactoring();
    }

    protected boolean showConflicts(MultiMap<PsiElement, String> conflicts) {
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            throw new ConflictsInTestsException(conflicts.values());
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/BaseRefactoringProcessor.getElementsToWrite must not be null");
        }
        List<PsiElement> list = Arrays.asList(descriptor.getElements());
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/BaseRefactoringProcessor.getElementsToWrite must not return null");
        }
        return list;
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(Language elementLanguage) {
            this.myElementLanguage = elementLanguage;
        }

        public Language getElementLanguage() {
            return this.myElementLanguage;
        }
    }

    public static class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore = false;

        public ConflictsInTestsException(Collection<? extends String> messages) {
            this.messages = messages;
        }

        public static void setTestIgnore(boolean myIgnore) {
            myTestIgnore = myIgnore;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        public Collection<String> getMessages() {
            ArrayList<String> result = new ArrayList<String>(this.messages);
            for (int i = 0; i < this.messages.size(); ++i) {
                result.set(i, ((String)result.get(i)).replaceAll("<[^>]+>", ""));
            }
            return result;
        }

        @Override
        public String getMessage() {
            return StringUtil.join(this.messages, (String)"\n");
        }
    }
}

