/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateBlackAndWhiteLexer;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.templateLanguages.TemplateDataElementType");
    private static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    private final IElementType myTemplateElementType;
    private final IElementType myOuterElementType;

    public TemplateDataElementType(@NonNls String debugName, Language language, IElementType templateElementType, IElementType outerElementType) {
        super(debugName, language);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    public ASTNode parseContents(ASTNode chameleon) {
        TreeElement element;
        CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement treeElement = new DummyHolder((PsiManager)((TreeElement)chameleon).getManager(), null, table).getTreeElement();
        PsiFile file = (PsiFile)TreeUtil.getFileElement((TreeElement)chameleon).getPsi();
        PsiFile originalFile = file.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalFile.getViewProvider();
        Language language = viewProvider.getTemplateDataLanguage();
        CharSequence chars = chameleon.getChars();
        Lexer baseLexer = this.createBaseLexer(viewProvider);
        CharSequence templateText = this.createTemplateText(chars, baseLexer);
        PsiFile templateFile = this.createFromText(language, templateText, file.getManager());
        CompositeElement parsed = ((PsiFileImpl)templateFile).calcTreeElement();
        Lexer langLexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).createLexer(file.getProject());
        MergingLexerAdapter lexer = new MergingLexerAdapter((Lexer)new TemplateBlackAndWhiteLexer(this.createBaseLexer(viewProvider), langLexer, this.myTemplateElementType, this.myOuterElementType), TokenSet.create((IElementType[])new IElementType[]{this.myTemplateElementType, this.myOuterElementType}));
        lexer.start(chars);
        this.insertOuters(parsed, (Lexer)lexer, table);
        if (parsed != null && (element = ((TreeElement)parsed).getFirstChildNode()) != null) {
            treeElement.rawAddChildren(element);
        }
        treeElement.clearCaches();
        treeElement.subtreeChanged();
        return treeElement.getFirstChildNode();
    }

    private CharSequence createTemplateText(CharSequence buf, Lexer lexer) {
        StringBuilder result = new StringBuilder(buf.length());
        lexer.start(buf);
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == this.myTemplateElementType) {
                result.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
            }
            lexer.advance();
        }
        return result;
    }

    private void insertOuters(TreeElement root, Lexer lexer, CharTable table) {
        TreePatcher patcher = (TreePatcher)TREE_PATCHER.forLanguage(root.getPsi().getLanguage());
        int treeOffset = 0;
        LeafElement leaf = TreeUtil.findFirstLeaf(root);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (tt != this.myTemplateElementType) {
                while (leaf != null && treeOffset < lexer.getTokenStart()) {
                    if ((treeOffset += leaf.getTextLength()) > lexer.getTokenStart()) {
                        leaf = patcher.split(leaf, leaf.getTextLength() - (treeOffset - lexer.getTokenStart()), table);
                        treeOffset = lexer.getTokenStart();
                    }
                    leaf = (LeafElement)TreeUtil.nextLeaf(leaf);
                }
                if (leaf == null) break;
                OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(lexer, table, this.myOuterElementType);
                patcher.insert(leaf.getTreeParent(), leaf, newLeaf);
                leaf.getTreeParent().subtreeChanged();
                leaf = newLeaf;
            }
            lexer.advance();
        }
        if (lexer.getTokenType() != null) {
            assert (lexer.getTokenType() != this.myTemplateElementType);
            OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(lexer, table, this.myOuterElementType);
            ((CompositeElement)root).rawAddChildren(newLeaf);
            ((CompositeElement)root).subtreeChanged();
        }
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(Lexer lexer, CharTable table, IElementType outerElementType) {
        int tokenEnd;
        CharSequence buffer = lexer.getBufferSequence();
        int tokenStart = lexer.getTokenStart();
        if (tokenStart < 0 || tokenStart > buffer.length()) {
            LOG.error("Invalid start: " + tokenStart + "; " + lexer);
        }
        if ((tokenEnd = lexer.getTokenEnd()) < 0 || tokenEnd > buffer.length()) {
            LOG.error("Invalid end: " + tokenEnd + "; " + lexer);
        }
        return new OuterLanguageElementImpl(outerElementType, table.intern(buffer, tokenStart, tokenEnd));
    }

    private PsiFile createFromText(final Language language, CharSequence text, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), text, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                Language language2 = language;
                if (language2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/templateLanguages/TemplateDataElementType$1.getBaseLanguage must not return null");
                }
                return language2;
            }
        };
        return viewProvider.getPsi(language);
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        public TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("" == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType.getDefaultExtension must not return null");
            }
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            String string = "fake for language" + this.myLanguage.getID();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType.getDescription must not return null");
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            String string = this.myLanguage.getID();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType.getName must not return null");
            }
            return string;
        }
    }
}

