/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.HashMap;
import java.util.List;

public class DuplicateConflictResolver
implements PsiConflictResolver {
    public static final DuplicateConflictResolver INSTANCE = new DuplicateConflictResolver();

    private DuplicateConflictResolver() {
    }

    @Override
    public CandidateInfo resolveConflict(List<CandidateInfo> conflicts) {
        HashMap uniqueItems = new HashMap();
        for (CandidateInfo info : conflicts) {
            PsiElement element = info.getElement();
            String key = element instanceof PsiMethod ? ((PsiMethod)element).getSignature(info.getSubstitutor()) : PsiUtilBase.getName((PsiElement)element);
            if (uniqueItems.containsKey(key)) continue;
            uniqueItems.put(key, info);
        }
        if (uniqueItems.size() == 1) {
            return (CandidateInfo)uniqueItems.values().iterator().next();
        }
        return null;
    }
}

