/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiThisExpressionImpl
extends ExpressionPsiElement
implements PsiThisExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiThisExpressionImpl");

    public PsiThisExpressionImpl() {
        super(THIS_EXPRESSION);
    }

    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiClass qualifierResolve = (PsiClass)qualifier.resolve();
            if (qualifierResolve != null) {
                return new PsiImmediateClassType(qualifierResolve, PsiSubstitutor.EMPTY);
            }
            return new PsiClassReferenceType(qualifier, null);
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentThisType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentThisType = ((JavaCodeFragment)scope).getThisType()) == null) continue;
            return fragmentThisType;
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 95: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == THIS_KEYWORD) {
            return 95;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiThisExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitThisExpression((PsiThisExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiThisExpression:" + this.getText();
    }
}

