/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedPsiCachedValueProvider;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageUtil {
    static final Key<List<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    private static final InjectedPsiCachedValueProvider INJECTED_PSI_PROVIDER = new InjectedPsiCachedValueProvider();
    private static final Key<ParameterizedCachedValue<MultiHostRegistrarImpl, PsiElement>> INJECTED_PSI_KEY = Key.create((String)"INJECTED_PSI");
    private static final Key<List<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");
    private static final Key<List<RangeMarker>> INJECTED_REGIONS_KEY = Key.create((String)"INJECTED_REGIONS_KEY");

    public static void forceInjectionOnElement(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.forceInjectionOnElement must not be null");
        }
        InjectedLanguageUtil.enumerate(host, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$1.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$1.visit must not be null");
                }
            }
        });
    }

    private static PsiElement loadTree(PsiElement host) {
        PsiElement context;
        PsiFile file = host.getContainingFile();
        if (file instanceof DummyHolder && (context = file.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        return host;
    }

    @Nullable
    public static List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedPsiFiles must not be null");
        }
        final PsiElement inTree = InjectedLanguageUtil.loadTree(host);
        SmartList result = new SmartList();
        InjectedLanguageUtil.enumerate(inTree, new PsiLanguageInjectionHost.InjectedPsiVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$2.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$2.visit must not be null");
                }
                for (PsiLanguageInjectionHost.Shred place : places) {
                    if (place.host != inTree) continue;
                    this.val$result.add(new Pair((Object)injectedPsi, (Object)place.getRangeInsideHost()));
                }
            }
        });
        return result.isEmpty() ? null : result;
    }

    public static TextRange toTextRange(RangeMarker marker) {
        return new ProperTextRange(marker.getStartOffset(), marker.getEndOffset());
    }

    public static List<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>> getHighlightTokens(PsiFile file) {
        return (List)file.getUserData(HIGHLIGHT_TOKENS);
    }

    public static Place getShreds(PsiFile injectedFile) {
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return myFileViewProvider.getShreds();
    }

    public static void enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.enumerate must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.enumerate must not be null");
        }
        PsiFile containingFile = host.getContainingFile();
        InjectedLanguageUtil.enumerate(host, containingFile, visitor, true);
    }

    public static void enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor, boolean probeUp) {
        MultiHostRegistrarImpl registrar;
        PsiElement inTree;
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.enumerate must not be null");
        }
        if (containingFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.enumerate must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.enumerate must not be null");
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile) {
            PsiElement context = containingFile.getContext();
            if (context == null) {
                return;
            }
            PsiFile file = context.getContainingFile();
            if (file == null || !file.isPhysical() && file.getOriginalFile() == file) {
                return;
            }
        }
        if ((inTree = InjectedLanguageUtil.loadTree(host)) != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((registrar = InjectedLanguageUtil.probeElementsUp(host, containingFile, probeUp)) == null) {
            return;
        }
        List<Pair<Place, PsiFile>> places = registrar.result;
        for (Pair<Place, PsiFile> pair : places) {
            PsiFile injectedPsi = (PsiFile)pair.second;
            visitor.visit(injectedPsi, (List)pair.first);
        }
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file, offset);
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file, int offset) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor editor, PsiFile injectedFile) {
        int selend;
        int selstart;
        Editor editor2;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not be null");
        }
        if (injectedFile == null || editor instanceof EditorWindow) {
            editor2 = editor;
            if (editor2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not return null");
            return editor2;
        }
        Document document = PsiDocumentManager.getInstance((Project)editor.getProject()).getDocument(injectedFile);
        if (!(document instanceof DocumentWindowImpl)) {
            editor2 = editor;
            if (editor2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not return null");
            return editor2;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() && !documentWindow.containsRange(selstart = selectionModel.getSelectionStart(), selend = selectionModel.getSelectionEnd())) {
            editor2 = editor;
            if (editor2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not return null");
            return editor2;
        }
        if (!documentWindow.isValid()) {
            editor2 = editor;
            if (editor2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not return null");
            return editor2;
        }
        editor2 = EditorWindow.create(documentWindow, (EditorImpl)editor, injectedFile);
        if (editor2 != null) return editor2;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getInjectedEditorForInjectedFile must not return null");
    }

    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInjectedPsiNoCommit must not be null");
        }
        PsiElement injected = InjectedLanguageUtil.findInjectedElementNoCommit(host, offset);
        if (injected != null) {
            return injected.getContainingFile();
        }
        return null;
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file, int offset) {
        PsiElement injected;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findElementAtNoCommit must not be null");
        }
        if (!InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file) && (injected = InjectedLanguageUtil.findInjectedElementNoCommit(file, offset)) != null) {
            return injected;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        return viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
    }

    private static MultiHostRegistrarImpl probeElementsUp(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.probeElementsUp must not be null");
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.probeElementsUp must not be null");
        }
        PsiManager psiManager = hostPsiFile.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        if (injectedManager == null) {
            return null;
        }
        for (PsiElement current = element; current != null && current != hostPsiFile; current = current.getParent()) {
            MultiHostRegistrarImpl registrar;
            ProgressManager.checkCanceled();
            if ("EL".equals(current.getLanguage().getID())) break;
            ParameterizedCachedValue data = (ParameterizedCachedValue)current.getUserData(INJECTED_PSI_KEY);
            if (data == null) {
                registrar = InjectedPsiCachedValueProvider.doCompute(current, injectedManager, project, hostPsiFile);
                if (registrar != null) {
                    ParameterizedCachedValue cachedValue = CachedValuesManager.getManager((Project)psiManager.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)INJECTED_PSI_PROVIDER, false);
                    Document hostDocument = hostPsiFile.getViewProvider().getDocument();
                    CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)registrar, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, hostDocument});
                    ((PsiParameterizedCachedValue)cachedValue).setValue(result);
                    current.putUserData(INJECTED_PSI_KEY, (Object)cachedValue);
                }
            } else {
                registrar = (MultiHostRegistrarImpl)data.getValue((Object)current);
            }
            if (registrar != null) {
                List<Pair<Place, PsiFile>> places = registrar.result;
                TextRange elementRange = element.getTextRange();
                for (Pair<Place, PsiFile> pair : places) {
                    Place place = (Place)((Object)pair.first);
                    Iterator i$ = place.iterator();
                    while (i$.hasNext()) {
                        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                        if (!shred.host.getTextRange().intersects(elementRange) || !place.isValid()) continue;
                        return registrar;
                    }
                }
            }
            if (!probeUp) break;
        }
        return null;
    }

    @Nullable
    public static PsiElement findInjectedElementNoCommitWithOffset(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInjectedElementNoCommitWithOffset must not be null");
        }
        Project project = file.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(file)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        FileViewProvider provider = file.getViewProvider();
        for (Language language : provider.getLanguages()) {
            PsiElement injected;
            PsiElement element = provider.findElementAt(offset, language);
            if (element == null || (injected = InjectedLanguageUtil.findInside(element, file, offset, documentManager)) == null) continue;
            return injected;
        }
        return null;
    }

    public static PsiElement findInjectedElementNoCommit(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInjectedElementNoCommit must not be null");
        }
        PsiElement inj = InjectedLanguageUtil.findInjectedElementNoCommitWithOffset(file, offset);
        if (inj != null) {
            return inj;
        }
        if (offset != 0) {
            inj = InjectedLanguageUtil.findInjectedElementNoCommitWithOffset(file, offset - 1);
        }
        return inj;
    }

    private static PsiElement findInside(@NotNull PsiElement element, @NotNull PsiFile file, final int offset, final @NotNull PsiDocumentManager documentManager) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInside must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInside must not be null");
        }
        if (documentManager == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.findInside must not be null");
        }
        final Ref out = new Ref();
        InjectedLanguageUtil.enumerate(element, file, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$3.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$3.visit must not be null");
                }
                for (PsiLanguageInjectionHost.Shred place : places) {
                    TextRange hostRange = place.host.getTextRange();
                    if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(offset)) continue;
                    DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                    int injectedOffset = document.hostToInjected(offset);
                    PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                    out.set(injElement == null ? injectedPsi : injElement);
                }
            }
        }, true);
        return (PsiElement)out.get();
    }

    @NotNull
    public static List<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        if (hostPsiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getCachedInjectedDocuments must not be null");
        }
        List injected = (List)hostPsiFile.getUserData(INJECTED_DOCS_KEY);
        if (injected == null) {
            injected = (List)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createEmptyCOWList());
        }
        List list = injected;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil.getCachedInjectedDocuments must not return null");
        }
        return list;
    }

    public static void commitAllInjectedDocuments(Document hostDocument, Project project) {
        List<RangeMarker> injected = InjectedLanguageUtil.getCachedInjectedRegions(hostDocument);
        if (injected.isEmpty()) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile hostPsiFile = documentManager.getPsiFile(hostDocument);
        assert (hostPsiFile != null);
        for (RangeMarker rangeMarker : injected) {
            PsiElement element;
            PsiElement psiElement = element = rangeMarker.isValid() ? hostPsiFile.findElementAt(rangeMarker.getStartOffset()) : null;
            if (element == null) {
                injected.remove(rangeMarker);
                continue;
            }
            InjectedLanguageUtil.enumerate(element, hostPsiFile, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$4.visit must not be null");
                    }
                    if (places == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$4.visit must not be null");
                    }
                    PsiDocumentManagerImpl.checkConsistency(injectedPsi, injectedPsi.getViewProvider().getDocument());
                }
            }, true);
        }
        EditorWindow.disposeInvalidEditors();
        PsiDocumentManagerImpl.checkConsistency(hostPsiFile, hostDocument);
    }

    public static void clearCaches(PsiFile injected) {
        VirtualFileWindow virtualFile = (VirtualFileWindow)injected.getVirtualFile();
        PsiManagerEx psiManagerEx = (PsiManagerEx)injected.getManager();
        psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null);
    }

    static List<RangeMarker> getCachedInjectedRegions(Document hostDocument) {
        List injectedRegions = (List)hostDocument.getUserData(INJECTED_REGIONS_KEY);
        if (injectedRegions == null) {
            injectedRegions = (List)((UserDataHolderEx)hostDocument).putUserDataIfAbsent(INJECTED_REGIONS_KEY, (Object)ContainerUtil.createEmptyCOWList());
        }
        return injectedRegions;
    }

    public static Editor openEditorFor(PsiFile file, Project project) {
        Editor editor;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            return EditorWindow.create((DocumentWindowImpl)document, (EditorImpl)editor, file);
        }
        return editor;
    }

    public static PsiFile getTopLevelFile(PsiElement element) {
        PsiElement host;
        PsiFile containingFile = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(containingFile);
        if (document instanceof DocumentWindow && (host = containingFile.getContext()) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    public static Editor getTopLevelEditor(Editor editor) {
        return editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(PsiElement element) {
        PsiFile injectedFile = element.getContainingFile();
        if (injectedFile == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element.getTextRange();
        List editables = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiablesLength = 0;
        for (TextRange editable : editables) {
            combinedEdiablesLength += editable.getLength();
        }
        return combinedEdiablesLength != elementRange.getLength();
    }

    public static boolean isSelectionIsAboutToOverflowInjectedFragment(EditorWindow injectedEditor) {
        boolean isEndOverflows;
        boolean isStartOverflows;
        int selStart = injectedEditor.getSelectionModel().getSelectionStart();
        int selEnd = injectedEditor.getSelectionModel().getSelectionEnd();
        DocumentWindowImpl document = injectedEditor.getDocument();
        boolean bl = isStartOverflows = selStart == 0;
        if (!isStartOverflows) {
            int hostPrev = document.injectedToHost(selStart - 1);
            isStartOverflows = document.hostToInjected(hostPrev) == selStart;
        }
        boolean bl2 = isEndOverflows = selEnd == document.getTextLength();
        if (!isEndOverflows) {
            int hostNext = document.injectedToHost(selEnd + 1);
            isEndOverflows = document.hostToInjected(hostNext) == selEnd;
        }
        return isStartOverflows && isEndOverflows;
    }
}

