/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LeafPsiElement
extends LeafElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LeafPsiElement");

    public LeafPsiElement(IElementType type, CharSequence text) {
        super(type, text);
    }

    @Deprecated
    public LeafPsiElement(IElementType type, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        super(type, table.intern(buffer, startOffset, endOffset));
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getFirstChild() {
        return null;
    }

    public PsiElement getLastChild() {
        return null;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.acceptChildren must not be null");
        }
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this);
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null || !file.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file;
    }

    public PsiElement findElementAt(int offset) {
        return this;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.addRangeBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.replace must not be null");
        }
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        this.getTreeParent().replaceChildInternal(this, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        this.invalidate();
        return result;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.accept must not be null");
        }
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafPsiElement.processDeclarations must not be null");
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafPsiElement.getLanguage must not return null");
        }
        return language;
    }

    public ASTNode getNode() {
        return this;
    }

    @Override
    public PsiElement getPsi() {
        return this;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        EditSourceUtil.getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public FileStatus getFileStatus() {
        if (!this.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = this.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile != null ? FileStatusManager.getInstance((Project)this.getProject()).getStatus(vFile) : FileStatus.NOT_CHANGED;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

