/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final int TEXT_MATCHES_THRESHOLD = 5;
    private final CharSequence myText;

    protected LeafElement(IElementType type, CharSequence text) {
        super(type);
        this.myText = text;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public CharSequence getChars() {
        return this.myText;
    }

    public String getText() {
        return ((Object)this.myText).toString();
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(char[] buffer, int start) {
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)start);
        }
        return start + this.myText.length();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)0);
        if (buffer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LeafElement.textToCharArray must not return null");
        }
        return buffer;
    }

    public boolean textContains(char c) {
        CharSequence text = this.myText;
        for (int i = 0; i < text.length(); ++i) {
            if (c != text.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(CharSequence buffer, int start) {
        CharSequence text = this.myText;
        return LeafElement.leafTextMatches(text, buffer, start);
    }

    public static int leafTextMatches(CharSequence text, CharSequence buffer, int start) {
        int length = text.length();
        if (buffer.length() - start < length) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) == buffer.charAt(i + start)) continue;
            return -1;
        }
        return start + length;
    }

    public LeafElement rawReplaceWithText(String newText) {
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo((UserDataHolderBase)newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        return newLeaf;
    }

    public LeafElement replaceWithText(String newText) {
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        return newLeaf;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(CharSequence buf, int start, int end) {
        CharSequence text = this.getChars();
        int len = text.length();
        if (end - start != len) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == buf.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitLeaf(this);
    }

    public ASTNode findChildByType(IElementType type) {
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.findChildByType must not be null");
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.findChildByType must not be null");
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    public static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    public ASTNode[] getChildren(TokenSet filter) {
        return EMPTY_ARRAY;
    }

    public void addChild(@NotNull ASTNode child, ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.addChild must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.addLeaf must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.addChild must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.removeChild must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.replaceChild must not be null");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.replaceChild must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LeafElement.removeRange must not be null");
        }
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new RuntimeException(new IncorrectOperationException("Leaf elements cannot have children."));
    }

    public PsiElement getPsi() {
        return null;
    }
}

