/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("com.intellij.psi.fileReferenceHelper");

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper.trimUrl must not be null");
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper.trimUrl must not return null");
        }
        return string;
    }

    @Nullable
    public List<? extends LocalQuickFix> registerFixes(HighlightInfo info, FileReference reference) {
        return Collections.emptyList();
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper.getPsiFileSystemItem must not be null");
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
    }

    @Nullable
    public abstract PsiFileSystemItem findRoot(Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract Collection<PsiFileSystemItem> getRoots(@NotNull Module var1);

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContexts(Project var1, @NotNull VirtualFile var2);

    public abstract boolean isMine(Project var1, @NotNull VirtualFile var2);
}

