/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveUtil {
    public static PsiClass getContextClass(PsiElement element) {
        for (PsiElement scope = element.getContext(); scope != null; scope = scope.getContext()) {
            if (!(scope instanceof PsiClass)) continue;
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiElement findParentContextOfClass(PsiElement element, Class aClass, boolean strict) {
        PsiElement scope;
        PsiElement psiElement = scope = strict ? element.getContext() : element;
        while (scope != null && !aClass.isInstance(scope)) {
            scope = scope.getContext();
        }
        return scope;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope) {
        PsiClass clazz;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        if (modifierList == null) {
            return true;
        }
        PsiFile placeContainingFile = place.getContainingFile();
        PsiManager manager = member.getManager();
        if (placeContainingFile instanceof JavaCodeFragment) {
            JavaCodeFragment fragment = (JavaCodeFragment)placeContainingFile;
            JavaCodeFragment.VisibilityChecker visibilityChecker = fragment.getVisibilityChecker();
            if (visibilityChecker != null) {
                JavaCodeFragment.VisibilityChecker.Visibility visibility = visibilityChecker.isDeclarationVisible((PsiElement)member, place);
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE) {
                    return true;
                }
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE) {
                    return false;
                }
            }
        } else if (placeContainingFile instanceof XmlFile && !JspPsiUtil.isInJspFile((PsiElement)placeContainingFile)) {
            return true;
        }
        if (JavaResolveUtil.isInJavaDoc(place)) {
            return true;
        }
        if (accessObjectClass != null && !JavaResolveUtil.isAccessible((PsiMember)accessObjectClass, accessObjectClass.getContainingClass(), accessObjectClass.getModifierList(), place, null, null)) {
            return false;
        }
        int effectiveAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        PsiFile file = FileContextUtil.getContextFile(place);
        if (JspPsiUtil.isInJspFile((PsiElement)file) && JspPsiUtil.isInJspFile((PsiElement)member.getContainingFile())) {
            return true;
        }
        if (file instanceof XmlFile && !JspPsiUtil.isInJspFile((PsiElement)file)) {
            return true;
        }
        if (effectiveAccessLevel == 4) {
            return true;
        }
        if (effectiveAccessLevel == 3) {
            if (JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)member, place)) {
                return true;
            }
            if (memberClass == null) {
                return false;
            }
            for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
                if (!(placeParent instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)placeParent), (PsiClass)memberClass, (boolean)true)) continue;
                if (member instanceof PsiClass || modifierList.hasModifierProperty("static")) {
                    return true;
                }
                if (accessObjectClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)accessObjectClass, (PsiClass)((PsiClass)placeParent), (boolean)true)) continue;
                return true;
            }
            return false;
        }
        if (effectiveAccessLevel == 1) {
            PsiClass topAccessClass;
            PsiClass topMemberClass;
            if (memberClass == null) {
                return true;
            }
            if (accessObjectClass != null && !manager.areElementsEquivalent((PsiElement)(topMemberClass = JavaResolveUtil.getTopLevelClass((PsiElement)memberClass, accessObjectClass)), (PsiElement)(topAccessClass = JavaResolveUtil.getTopLevelClass((PsiElement)accessObjectClass, memberClass)))) {
                return false;
            }
            if (fileResolveScope == null) {
                PsiClass placeTopLevelClass = JavaResolveUtil.getTopLevelClass(place, null);
                PsiClass memberTopLevelClass = JavaResolveUtil.getTopLevelClass((PsiElement)memberClass, null);
                return manager.areElementsEquivalent((PsiElement)placeTopLevelClass, (PsiElement)memberTopLevelClass);
            }
            return fileResolveScope instanceof PsiClass && !((PsiClass)fileResolveScope).isInheritor(memberClass, true);
        }
        if (!JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)member, place)) {
            return false;
        }
        if (modifierList.hasModifierProperty("static")) {
            return true;
        }
        PsiClass placeClass = JavaResolveUtil.getContextClass(place);
        if (memberClass == null || placeClass == null) {
            return true;
        }
        if (memberClass.isInterface() || placeClass.isInterface()) {
            return true;
        }
        PsiClass psiClass = clazz = accessObjectClass != null ? accessObjectClass : placeClass.getSuperClass();
        if (clazz != null && clazz.isInheritor(memberClass, true)) {
            PsiClass superClass = clazz;
            while (!manager.areElementsEquivalent((PsiElement)superClass, (PsiElement)memberClass)) {
                if (superClass == null || !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)superClass, (PsiElement)memberClass)) {
                    return false;
                }
                superClass = superClass.getSuperClass();
            }
        }
        return true;
    }

    public static boolean isInJavaDoc(PsiElement place) {
        for (PsiElement scope = place; scope != null; scope = scope.getContext()) {
            if (scope instanceof PsiDocComment) {
                return true;
            }
            if (!(scope instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    private static PsiClass getTopLevelClass(@NotNull PsiElement place, PsiClass memberClass) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.getTopLevelClass must not be null");
        }
        PsiClass lastClass = null;
        for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
            if (!(placeParent instanceof PsiClass) || placeParent instanceof PsiAnonymousClass || placeParent instanceof PsiTypeParameter) continue;
            PsiClass aClass = (PsiClass)placeParent;
            if (memberClass != null && aClass.isInheritor(memberClass, true)) {
                return aClass;
            }
            lastClass = aClass;
        }
        return lastClass;
    }

    public static boolean processImplicitlyImportedPackages(PsiScopeProcessor processor, ResolveState state, PsiElement place, PsiManager manager) {
        PsiPackage langPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("java.lang");
        if (langPackage != null && !langPackage.processDeclarations(processor, state, null, place)) {
            return false;
        }
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
        return defaultPackage == null || defaultPackage.processDeclarations(processor, state, null, place);
    }
}

