/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.GTTokens;
import com.intellij.psi.impl.source.parsing.MissingTokenInserter;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.ModifierListElement;
import com.intellij.psi.jsp.AbstractJspJavaLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;

public class ParseUtil {
    public static TreeElement createTokenElement(Lexer lexer, CharTable table) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.DOC_COMMENT) {
            return ASTFactory.lazy(JavaDocElementType.DOC_COMMENT, LexerUtil.internToken((Lexer)lexer, (CharTable)table));
        }
        return ASTFactory.leaf(tokenType, LexerUtil.internToken((Lexer)lexer, (CharTable)table));
    }

    public static void insertMissingTokens(CompositeElement root, Lexer lexer, int startOffset, int endOffset, int state, TokenProcessor processor, ParsingContext context) {
        MissingTokenInserter inserter = lexer instanceof JavaLexer || lexer instanceof AbstractJspJavaLexer ? new JavaMissingTokenInserter(root, lexer, startOffset, endOffset, state, processor, context) : new MissingTokenInserter(root, lexer, startOffset, endOffset, state, processor, context);
        ((MissingTokenInserter)inserter).invoke();
    }

    private static class JavaMissingTokenInserter
    extends MissingTokenInserter {
        private static final TokenSet BIND_TRAILING_COMMENT_BIT_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JavaElementType.FIELD, JavaElementType.METHOD, JavaElementType.CLASS, JavaElementType.CLASS_INITIALIZER, JavaElementType.IMPORT_STATEMENT, JavaElementType.IMPORT_STATIC_STATEMENT, JavaElementType.PACKAGE_STATEMENT}), ElementType.JAVA_STATEMENT_BIT_SET});
        private static final TokenSet BIND_PRECEDING_COMMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.FIELD, JavaElementType.METHOD, JavaElementType.CLASS, JavaElementType.CLASS_INITIALIZER});
        private static final TokenSet PRECEDING_COMMENT_OR_SPACE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.C_STYLE_COMMENT, JavaTokenType.END_OF_LINE_COMMENT, JavaDocElementType.DOC_COMMENT, TokenType.WHITE_SPACE});

        public JavaMissingTokenInserter(CompositeElement root, Lexer lexer, int startOffset, int endOffset, int state, TokenProcessor processor, ParsingContext context) {
            super(root, lexer, startOffset, endOffset, state, processor, context);
        }

        @Override
        public void invoke() {
            super.invoke();
            JavaMissingTokenInserter.bindComments(this.myRoot);
        }

        @Override
        protected IElementType getNextTokenType() {
            return GTTokens.getTokenType(this.myLexer);
        }

        @Override
        protected void advanceLexer(ASTNode next) {
            GTTokens.advance(next.getElementType(), this.myLexer);
        }

        private static void bindComments(ASTNode root) {
            if (TreeUtil.isLeafOrCollapsedChameleon(root)) {
                return;
            }
            SmartList comments = new SmartList();
            ((TreeElement)root).acceptTree(new RecursiveTreeElementWalkingVisitor(false, (List)comments){
                final /* synthetic */ List val$comments;
                {
                    this.val$comments = list;
                    super(x0);
                }

                @Override
                protected void visitNode(TreeElement child) {
                    IElementType type = child.getElementType();
                    if (type == JavaDocElementType.DOC_COMMENT || type == JavaTokenType.END_OF_LINE_COMMENT || type == JavaTokenType.C_STYLE_COMMENT) {
                        this.val$comments.add(child);
                    }
                    if (TreeUtil.isLeafOrCollapsedChameleon(child)) {
                        return;
                    }
                    super.visitNode(child);
                }
            });
            boolean docCommentBound = false;
            Iterator iterator = comments.iterator();
            while (iterator.hasNext()) {
                ASTNode child = (ASTNode)iterator.next();
                IElementType type = child.getElementType();
                if (type == JavaDocElementType.DOC_COMMENT) {
                    if (!JavaMissingTokenInserter.bindDocComment((TreeElement)child)) continue;
                    iterator.remove();
                    docCommentBound = true;
                    continue;
                }
                if (type != JavaTokenType.END_OF_LINE_COMMENT && type != JavaTokenType.C_STYLE_COMMENT || !JavaMissingTokenInserter.bindTrailingComment((TreeElement)child)) continue;
                iterator.remove();
            }
            if (!docCommentBound) {
                for (ASTNode child : comments) {
                    if (child.getElementType() != JavaTokenType.END_OF_LINE_COMMENT && child.getElementType() != JavaTokenType.C_STYLE_COMMENT) continue;
                    TreeElement next = (TreeElement)TreeUtil.skipElements(child, PRECEDING_COMMENT_OR_SPACE_BIT_SET);
                    JavaMissingTokenInserter.bindPrecedingComment((TreeElement)child, next);
                }
            }
        }

        private static boolean bindDocComment(TreeElement docComment) {
            TreeElement element = docComment.getTreeNext();
            if (element == null) {
                return false;
            }
            TreeElement startSpaces = null;
            TreeElement importList = null;
            while (element.getElementType() == TokenType.WHITE_SPACE || element.getElementType() == JavaTokenType.C_STYLE_COMMENT || element.getElementType() == JavaTokenType.END_OF_LINE_COMMENT || element.getElementType() == JavaElementType.IMPORT_LIST && element.getTextLength() == 0) {
                if (element.getElementType() == JavaElementType.IMPORT_LIST) {
                    importList = element;
                }
                if (startSpaces == null) {
                    startSpaces = element;
                }
                if ((element = element.getTreeNext()) != null) continue;
                return false;
            }
            if (element.getElementType() == JavaElementType.CLASS || element.getElementType() == JavaElementType.FIELD || element.getElementType() == JavaElementType.METHOD || element.getElementType() == JavaElementType.ENUM_CONSTANT || element.getElementType() == JavaElementType.ANNOTATION_METHOD) {
                TreeElement first = element.getFirstChildNode();
                if (startSpaces != null) {
                    docComment.rawRemoveUpTo(element);
                } else {
                    docComment.rawRemove();
                }
                first.rawInsertBeforeMe(docComment);
                if (importList != null) {
                    importList.rawRemove();
                    element.rawInsertBeforeMe(importList);
                }
                return true;
            }
            return false;
        }

        private static boolean bindTrailingComment(TreeElement comment) {
            TreeElement element = comment.getTreePrev();
            if (element == null) {
                return false;
            }
            TreeElement space = null;
            if (element.getElementType() == TokenType.WHITE_SPACE) {
                space = element;
                element = element.getTreePrev();
            }
            if (!(element == null || !BIND_TRAILING_COMMENT_BIT_SET.contains(element.getElementType()) || space != null && (space.textContains('\n') || space.textContains('\r')) || comment.textContains('\n') || comment.textContains('\r'))) {
                if (space != null) {
                    space.rawRemove();
                    ((CompositeElement)element).rawAddChildren(space);
                }
                comment.rawRemove();
                ((CompositeElement)element).rawAddChildren(comment);
                return true;
            }
            return false;
        }

        private static void bindPrecedingComment(TreeElement comment, ASTNode bindTo) {
            TreeElement toStart;
            if (bindTo == null || bindTo.getFirstChildNode() != null && bindTo.getFirstChildNode().getElementType() == JavaTokenType.DOC_COMMENT) {
                return;
            }
            if (bindTo.getElementType() == JavaElementType.IMPORT_LIST && bindTo.getTextLength() == 0) {
                bindTo = bindTo.getTreeNext();
            }
            TreeElement treeElement = toStart = JavaMissingTokenInserter.isBindingComment(comment) ? comment : null;
            if (bindTo != null && BIND_PRECEDING_COMMENT_BIT_SET.contains(bindTo.getElementType())) {
                for (TreeElement child = comment; child != bindTo; child = child.getTreeNext()) {
                    if (child.getElementType() == TokenType.WHITE_SPACE) {
                        int count = StringUtil.getLineBreakCount((CharSequence)child.getText());
                        if (count <= 1) continue;
                        toStart = null;
                        continue;
                    }
                    if (child.getTreePrev() != null && child.getTreePrev().getElementType() == TokenType.WHITE_SPACE) {
                        LeafElement prev = (LeafElement)child.getTreePrev();
                        char lastC = prev.charAt(prev.getTextLength() - 1);
                        if (lastC != '\n' && lastC != '\r') continue;
                        toStart = JavaMissingTokenInserter.isBindingComment(child) ? child : null;
                        continue;
                    }
                    return;
                }
                if (toStart == null) {
                    return;
                }
                TreeElement first = (TreeElement)bindTo.getFirstChildNode();
                TreeElement child = toStart;
                while (child != bindTo) {
                    TreeElement next = child.getTreeNext();
                    if (child.getElementType() != JavaElementType.IMPORT_LIST) {
                        child.rawRemove();
                        first.rawInsertBeforeMe(child);
                    }
                    child = next;
                }
            }
        }

        private static boolean isBindingComment(ASTNode node) {
            ASTNode prev = node.getTreePrev();
            if (prev != null) {
                if (prev.getElementType() != TokenType.WHITE_SPACE) {
                    return false;
                }
                if (!prev.textContains('\n')) {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected boolean isInsertAfterElement(TreeElement treeNext) {
            return treeNext instanceof ModifierListElement;
        }
    }
}

