/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.JavaDocLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NonNls;

public class JavadocParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.JavadocParsing");
    private static final TokenSet TOKEN_FILTER = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_SPACE, JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS});
    private static final TokenSet TAG_VALUE = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT});
    private int myBraceScope = 0;
    @NonNls
    private static final String SEE_TAG = "@see";
    @NonNls
    private static final String LINK_TAG = "@link";
    @NonNls
    private static final String LINKPLAIN_TAG = "@linkplain";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    @NonNls
    private static final String EXCEPTION_TAG = "@exception";
    @NonNls
    private static final String PARAM_TAG = "@param";
    @NonNls
    private static final String VALUE_TAG = "@value";

    public JavadocParsing(JavaParsingContext context) {
        super(context);
    }

    public TreeElement parseJavaDocReference(CharSequence myBuffer, Lexer originalLexer, boolean isType, PsiManager manager) {
        FilterLexer lexer = new FilterLexer(originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(myBuffer);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        CompositeElement element = isType ? this.parseTypeWithEllipsis((Lexer)lexer, true, false) : this.myContext.getStatementParsing().parseJavaCodeReference((Lexer)lexer, true, true, false);
        if (element != null) {
            dummyRoot.rawAddChildren(element);
        }
        while (lexer.getTokenType() != null) {
            dummyRoot.rawAddChildren(ParseUtil.createTokenElement((Lexer)lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        ParseUtil.insertMissingTokens(dummyRoot, originalLexer, 0, myBuffer.length(), 0, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return dummyRoot.getFirstChildNode();
    }

    public TreeElement parseDocCommentText(PsiManager manager, CharSequence buffer, int startOffset, int endOffset) {
        IElementType tokenType;
        JavaDocLexer originalLexer = new JavaDocLexer(LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel().hasEnumKeywordAndAutoboxing());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(TOKEN_FILTER));
        lexer.start(buffer, startOffset, endOffset);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                CompositeElement tag = this.parseTag(manager, (Lexer)lexer);
                dummyRoot.rawAddChildren(tag);
                continue;
            }
            TreeElement element = this.parseDataItem(manager, (Lexer)lexer, null, false);
            dummyRoot.rawAddChildren(element);
        }
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, startOffset, endOffset, -1, new JDTokenProcessor(this), this.myContext);
        return dummyRoot.getFirstChildNode();
    }

    private CompositeElement parseTag(PsiManager manager, Lexer lexer) {
        IElementType tokenType;
        if (lexer.getTokenType() != JavaDocTokenType.DOC_TAG_NAME) {
            return null;
        }
        CompositeElement tag = ASTFactory.composite(JavaDocElementType.DOC_TAG);
        tag.rawAddChildren(this.createTokenElement(lexer));
        String tagName = ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
        lexer.advance();
        while ((tokenType = lexer.getTokenType()) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            TreeElement element = this.parseDataItem(manager, lexer, tagName, false);
            tag.rawAddChildren(element);
        }
        return tag;
    }

    private TreeElement parseDataItem(PsiManager manager, Lexer lexer, String tagName, boolean isInlineItem) {
        if (lexer.getTokenType() == JavaDocTokenType.DOC_INLINE_TAG_START) {
            LeafElement justABrace = ASTFactory.leaf(JavaDocTokenType.DOC_COMMENT_DATA, this.myContext.tokenText(lexer));
            CompositeElement tag = ASTFactory.composite(JavaDocElementType.DOC_INLINE_TAG);
            LeafElement leafElement = ASTFactory.leaf(JavaDocTokenType.DOC_INLINE_TAG_START, this.myContext.tokenText(lexer));
            tag.rawAddChildren(leafElement);
            lexer.advance();
            if (this.myBraceScope > 0) {
                ++this.myBraceScope;
                return justABrace;
            }
            if (lexer.getTokenType() != JavaDocTokenType.DOC_TAG_NAME && lexer.getTokenType() != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                return justABrace;
            }
            ++this.myBraceScope;
            String inlineTagName = "";
            while (true) {
                IElementType tokenType;
                if ((tokenType = lexer.getTokenType()) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
                }
                if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                TreeElement element = this.parseDataItem(manager, lexer, inlineTagName, true);
                tag.rawAddChildren(element);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                if (this.myBraceScope > 0) {
                    --this.myBraceScope;
                }
                if (this.myBraceScope == 0) break;
            }
            return tag;
        }
        if (TAG_VALUE.contains(lexer.getTokenType())) {
            if (SEE_TAG.equals(tagName) && !isInlineItem) {
                return this.parseSeeTagValue(lexer);
            }
            if (LINK_TAG.equals(tagName) && isInlineItem) {
                return this.parseSeeTagValue(lexer);
            }
            if (LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel().compareTo((Enum)LanguageLevel.JDK_1_4) >= 0 && LINKPLAIN_TAG.equals(tagName) && isInlineItem) {
                return this.parseSeeTagValue(lexer);
            }
            if (!isInlineItem && (THROWS_TAG.equals(tagName) || EXCEPTION_TAG.equals(tagName))) {
                TreeElement element = this.parseReferenceOrType(lexer, false);
                lexer.advance();
                CompositeElement tagValue = ASTFactory.composite(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                tagValue.rawAddChildren(element);
                return tagValue;
            }
            if (!isInlineItem && tagName != null && tagName.equals(PARAM_TAG)) {
                return this.parseParamTagValue(lexer);
            }
            if (LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel().compareTo((Enum)LanguageLevel.JDK_1_5) >= 0 && VALUE_TAG.equals(tagName) && isInlineItem) {
                return this.parseSeeTagValue(lexer);
            }
            return this.parseSimpleTagValue(lexer);
        }
        LeafElement token = this.createTokenElement(lexer);
        lexer.advance();
        return token;
    }

    private TreeElement parseParamTagValue(Lexer lexer) {
        CompositeElement tagValue = ASTFactory.composite(JavaDocElementType.DOC_PARAMETER_REF);
        while (TAG_VALUE.contains(lexer.getTokenType())) {
            LeafElement value = this.createTokenElement(lexer);
            lexer.advance();
            tagValue.rawAddChildren(value);
        }
        return tagValue;
    }

    private TreeElement parseSimpleTagValue(Lexer lexer) {
        CompositeElement tagValue = ASTFactory.composite(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        while (TAG_VALUE.contains(lexer.getTokenType())) {
            LeafElement value = this.createTokenElement(lexer);
            lexer.advance();
            tagValue.rawAddChildren(value);
        }
        return tagValue;
    }

    private ASTNode parseMethodRef(Lexer lexer) {
        CompositeElement ref = ASTFactory.composite(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
        LeafElement sharp = this.createTokenElement(lexer);
        ref.rawAddChildren(sharp);
        lexer.advance();
        if (lexer.getTokenType() != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            return ref;
        }
        LeafElement value = this.createTokenElement(lexer);
        ref.rawAddChildren(value);
        lexer.advance();
        if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            LeafElement lparen = this.createTokenElement(lexer);
            lexer.advance();
            ref.rawAddChildren(lparen);
            CompositeElement subValue = ASTFactory.composite(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            ref.rawAddChildren(subValue);
            while (TAG_VALUE.contains(lexer.getTokenType())) {
                if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    TreeElement reference = this.parseReferenceOrType(lexer, true);
                    lexer.advance();
                    subValue.rawAddChildren(reference);
                    while (TAG_VALUE.contains(lexer.getTokenType()) && lexer.getTokenType() != JavaDocTokenType.DOC_TAG_VALUE_COMMA && lexer.getTokenType() != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        LeafElement tokenElement = this.createTokenElement(lexer);
                        lexer.advance();
                        subValue.rawAddChildren(tokenElement);
                    }
                    continue;
                }
                if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    LeafElement rparen = this.createTokenElement(lexer);
                    lexer.advance();
                    ref.rawAddChildren(rparen);
                    return ref;
                }
                LeafElement tokenElement = this.createTokenElement(lexer);
                lexer.advance();
                subValue.rawAddChildren(tokenElement);
            }
        }
        return ref;
    }

    private TreeElement parseSeeTagValue(Lexer lexer) {
        if (!TAG_VALUE.contains(lexer.getTokenType())) {
            return null;
        }
        if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return (TreeElement)this.parseMethodRef(lexer);
        }
        if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            TreeElement element = this.parseReferenceOrType(lexer, false);
            lexer.advance();
            if (lexer.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                ASTNode methodRef = this.parseMethodRef(lexer);
                ((TreeElement)methodRef.getFirstChildNode()).rawInsertBeforeMe(element);
                return (TreeElement)methodRef;
            }
            return element;
        }
        CompositeElement tagValue = ASTFactory.composite(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        LeafElement element = this.createTokenElement(lexer);
        lexer.advance();
        tagValue.rawAddChildren(element);
        return tagValue;
    }

    private TreeElement parseReferenceOrType(Lexer lexer, boolean isType) {
        return ASTFactory.lazy(isType ? JavaDocElementType.DOC_TYPE_HOLDER : JavaDocElementType.DOC_REFERENCE_HOLDER, this.myContext.tokenText(lexer));
    }

    private LeafElement createTokenElement(Lexer lexer) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == JavaDocTokenType.DOC_SPACE) {
            tokenType = TokenType.WHITE_SPACE;
        } else if ((tokenType == JavaDocTokenType.DOC_INLINE_TAG_START || tokenType == JavaDocTokenType.DOC_INLINE_TAG_END) && this.myBraceScope != 1) {
            tokenType = JavaDocTokenType.DOC_COMMENT_DATA;
        }
        return ASTFactory.leaf(tokenType, this.myContext.tokenText(lexer));
    }

    private static class JDTokenProcessor
    implements TokenProcessor {
        private final JavadocParsing myParsing;

        private JDTokenProcessor(JavadocParsing theParsing) {
            this.myParsing = theParsing;
        }

        @Override
        public TreeElement process(Lexer lexer, ParsingContext context) {
            LeafElement first = null;
            TreeElement last = null;
            while (this.isTokenValid(lexer.getTokenType())) {
                LeafElement tokenElement = this.myParsing.createTokenElement(lexer);
                IElementType type = lexer.getTokenType();
                if (!TOKEN_FILTER.contains(type)) {
                    LOG.error("Missed token should be space or asterisks:" + tokenElement);
                    throw new RuntimeException();
                }
                if (last != null) {
                    last.setTreeNext(tokenElement);
                    tokenElement.setTreePrev(last);
                    last = tokenElement;
                } else {
                    last = tokenElement;
                    first = last;
                }
                lexer.advance();
            }
            return first;
        }

        @Override
        public boolean isTokenValid(IElementType tokenType) {
            return tokenType != null && TOKEN_FILTER.contains(tokenType);
        }
    }
}

