/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LightMethod
extends LightElement
implements PsiMethod {
    private final PsiMethod myMethod;
    private final PsiClass myContainingClass;

    public LightMethod(PsiManager manager, PsiMethod method, PsiClass containingClass) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myMethod = method;
        this.myContainingClass = containingClass;
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation(this);
    }

    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myMethod.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    public PsiDocComment getDocComment() {
        return this.myMethod.getDocComment();
    }

    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMethod.setName must not be null");
        }
        return this.myMethod.setName(name);
    }

    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getName must not return null");
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = this.myMethod.getHierarchicalMethodSignature();
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMethod.hasModifierProperty must not be null");
        }
        return this.myMethod.hasModifierProperty(name);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myMethod.getModifierList();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getModifierList must not return null");
        }
        return psiModifierList;
    }

    public PsiType getReturnType() {
        return this.myMethod.getReturnType();
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myMethod.getReturnTypeElement();
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.myMethod.getParameterList();
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myMethod.getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return this.myMethod.getBody();
    }

    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    public boolean isVarArgs() {
        return this.myMethod.isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMethod.getSignature must not be null");
        }
        MethodSignature methodSignature = this.myMethod.getSignature(substitutor);
        if (methodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getSignature must not return null");
        }
        return methodSignature;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myMethod.getNameIdentifier();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list = this.myMethod.findSuperMethodSignaturesIncludingStatic(checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return this.myMethod.findDeepestSuperMethod();
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findDeepestSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    public String getText() {
        return this.myMethod.getText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMethod.accept must not be null");
        }
        this.myMethod.accept(visitor);
    }

    public PsiElement copy() {
        return new LightMethod(this.myManager, (PsiMethod)this.myMethod.copy(), this.myContainingClass);
    }

    @Override
    public boolean isValid() {
        return this.myContainingClass.isValid();
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? Icons.ABSTRACT_METHOD_ICON : Icons.METHOD_ICON;
        RowIcon baseIcon = LightMethod.createLayeredIcon((Icon)methodIcon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMethod.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }
}

