/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightMemberReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final PsiMember myRefMember;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    public LightMemberReference(PsiManager manager, PsiMember refClass, PsiSubstitutor substitutor) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myRefMember = refClass;
        this.mySubstitutor = substitutor;
    }

    public PsiElement resolve() {
        return this.myRefMember;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        CandidateInfo candidateInfo = new CandidateInfo(resolved, substitutor);
        if (candidateInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMemberReference.advancedResolve must not return null");
        }
        return candidateInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMemberReference.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMemberReference.multiResolve must not return null");
    }

    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    public String getQualifiedName() {
        String qualifiedName;
        PsiClass containingClass = this.myRefMember.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return qualifiedName + '.' + this.myRefMember.getName();
        }
        return this.myRefMember.getName();
    }

    public String getReferenceName() {
        return this.getQualifiedName();
    }

    public String getText() {
        return this.myRefMember.getName() + this.getParameterList().getText();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            return null;
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            return name;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        return buf.toString();
    }

    public PsiElement copy() {
        return new LightMemberReference(this.myManager, this.myRefMember, this.mySubstitutor);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMemberReference.bindToElement must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightMemberReference.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myRefMember.getName();
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiClass && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isValid()) {
            return false;
        }
        return this.myRefMember == null || this.myRefMember.isValid();
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList == null ? PsiType.EMPTY_ARRAY : parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightMemberReference.getTypeParameters must not return null");
        }
        return psiTypeArray;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }
}

