/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import com.intellij.psi.impl.source.tree.java.AnonymousClassElement;
import com.intellij.psi.impl.source.tree.java.EnumConstantInitializerElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaClassElementType
extends JavaStubElementType<PsiClassStub, PsiClass> {
    public JavaClassElementType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.<init> must not be null");
        }
        super(id);
    }

    public PsiClass createPsi(PsiClassStub stub) {
        if (this.isCompiled(stub)) {
            return new ClsClassImpl(stub);
        }
        if (stub.isEnumConstantInitializer()) {
            return new PsiEnumConstantInitializerImpl(stub);
        }
        if (stub.isAnonymous()) {
            return new PsiAnonymousClassImpl(stub);
        }
        return new PsiClassImpl(stub);
    }

    @Override
    public PsiClass createPsi(ASTNode node) {
        if (node instanceof EnumConstantInitializerElement) {
            return new PsiEnumConstantInitializerImpl(node);
        }
        if (node instanceof AnonymousClassElement) {
            return new PsiAnonymousClassImpl(node);
        }
        return new PsiClassImpl(node);
    }

    public PsiClassStub createStub(PsiClass psi, StubElement parentStub) {
        boolean isAnonymous = psi instanceof PsiAnonymousClass;
        boolean isEnumConst = psi instanceof PsiEnumConstantInitializer;
        byte flags = PsiClassStubImpl.packFlags(RecordUtil.isDeprecatedByDocComment((PsiElement)psi), psi.isInterface(), psi.isEnum(), isEnumConst, isAnonymous, psi.isAnnotationType(), isAnonymous && ((PsiAnonymousClass)psi).isInQualifiedNew(), RecordUtil.isDeprecatedByAnnotation((PsiElement)psi));
        String baseRef = isAnonymous ? ((PsiAnonymousClass)psi).getBaseClassReference().getText() : null;
        JavaClassElementType type = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        return new PsiClassStubImpl(type, parentStub, psi.getQualifiedName(), psi.getName(), baseRef, flags);
    }

    public static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst) {
        return enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS);
    }

    public void serialize(PsiClassStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeByte((int)((PsiClassStubImpl)stub).getFlags());
        if (!stub.isAnonymous()) {
            dataStream.writeName(stub.getName());
            dataStream.writeName(stub.getQualifiedName());
            dataStream.writeName(stub.getSourceFileName());
        } else {
            dataStream.writeName(stub.getBaseClassReferenceText());
        }
    }

    public PsiClassStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte flags = dataStream.readByte();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        JavaClassElementType type = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        if (!isAnonymous) {
            StringRef name = dataStream.readName();
            StringRef qname = dataStream.readName();
            StringRef sourceFileName = dataStream.readName();
            PsiClassStubImpl classStub = new PsiClassStubImpl(type, parentStub, qname, name, null, flags);
            classStub.setSourceFileName(sourceFileName);
            return classStub;
        }
        StringRef baseref = dataStream.readName();
        return new PsiClassStubImpl(type, parentStub, null, null, baseref, flags);
    }

    public void indexStub(PsiClassStub stub, IndexSink sink) {
        boolean isAnonymous = stub.isAnonymous();
        if (isAnonymous) {
            String baseref = stub.getBaseClassReferenceText();
            if (baseref != null) {
                sink.occurrence(JavaAnonymousClassBaseRefOccurenceIndex.KEY, (Object)PsiNameHelper.getShortClassName((String)baseref));
            }
        } else {
            String fqn;
            String shortname = stub.getName();
            if (shortname != null) {
                sink.occurrence(JavaShortClassNameIndex.KEY, (Object)shortname);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(JavaFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
    }

    public String getId(PsiClassStub stub) {
        String name = stub.getName();
        if (name != null) {
            return name;
        }
        return super.getId((StubElement)stub);
    }
}

