/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiJavaDirectoryImpl;
import org.jetbrains.annotations.NotNull;

public class PsiJavaDirectoryFactory
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiJavaDirectoryFactory(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public PsiDirectory createDirectory(VirtualFile file) {
        return new PsiJavaDirectoryImpl(this.myManager, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        String string;
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiJavaDirectoryFactory.getQualifiedName must not be null");
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage != null) {
            String qualifiedName = aPackage.getQualifiedName();
            if (qualifiedName.length() > 0) {
                String string2 = qualifiedName;
                string = string2;
                if (string2 != null) return string;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiJavaDirectoryFactory.getQualifiedName must not return null");
            }
            if (!presentable) return "";
            String string3 = PsiBundle.message((String)"default.package.presentation", (Object[])new Object[0]) + " (" + directory.getVirtualFile().getPresentableUrl() + ")";
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiJavaDirectoryFactory.getQualifiedName must not return null");
            return string;
        }
        if (!presentable) return "";
        String string4 = directory.getVirtualFile().getPresentableUrl();
        string = string4;
        if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiJavaDirectoryFactory.getQualifiedName must not return null");
        return string;
    }

    @Override
    public boolean isPackage(PsiDirectory directory) {
        return ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile()) != null;
    }

    @Override
    public boolean isValidPackageName(String name) {
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isQualifiedName(name);
    }
}

