/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.IconSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/DirectoryIconProvider.getIcon must not be null");
        }
        if (element instanceof PsiDirectory) {
            boolean isOpen;
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile vFile = psiDirectory.getVirtualFile();
            boolean inTestSource = ProjectRootsUtil.isInTestSource(vFile, psiDirectory.getProject());
            boolean isSourceOrTestRoot = ProjectRootsUtil.isSourceOrTestRoot(vFile, psiDirectory.getProject());
            boolean bl = isOpen = (flags & 4) != 0;
            if (isSourceOrTestRoot) {
                return IconSet.getSourceRootIcon(inTestSource, isOpen);
            }
            return isOpen ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON;
        }
        return null;
    }
}

