/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl");
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;
    @NonNls
    private static final String EXTENDS_PREFIX = "?extends";
    @NonNls
    private static final String SUPER_PREFIX = "?super";

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, String canonicalText) {
        this.myParent = parent;
        this.myCanonicalText = canonicalText;
        String[] classParametersText = PsiNameHelper.getClassParametersText((String)canonicalText);
        int length = classParametersText.length;
        this.myTypeParameters = length == 0 ? ClsTypeElementImpl.EMPTY_ARRAY : new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParametersText[length - i - 1];
            char variance = '\u0000';
            if (s.startsWith(EXTENDS_PREFIX)) {
                variance = '+';
                s = s.substring(EXTENDS_PREFIX.length());
            } else if (s.startsWith(SUPER_PREFIX)) {
                variance = '-';
                s = s.substring(SUPER_PREFIX.length());
            } else if (StringUtil.startsWithChar((CharSequence)s, (char)'?')) {
                variance = '*';
                s = s.substring(1);
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance);
        }
        this.myQualifiedName = PsiNameHelper.getQualifiedClassName((String)this.myCanonicalText, (boolean)false);
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    public String getCanonicalText() {
        return this.myCanonicalText;
    }

    private JavaResolveResult advancedResolveImpl() {
        PsiElement resolve = this.resolveElement();
        if (resolve instanceof PsiClass) {
            HashMap substitutionMap = new HashMap();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiClass)resolve))) {
                if (index >= this.myTypeParameters.length) {
                    substitutionMap.put(parameter, null);
                } else {
                    substitutionMap.put(parameter, this.myTypeParameters[index].getType());
                }
                ++index;
            }
            return new CandidateInfo(resolve, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveCache resolveCache = ((PsiManagerEx)this.getManager()).getResolveCache();
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode);
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.multiResolve must not return null");
        }
        return javaResolveResultArray;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    private PsiElement resolveElement() {
        PsiElement element;
        for (element = this.getParent(); element != null && (!(element instanceof PsiClass) || element instanceof PsiTypeParameter); element = element.getParent()) {
            PsiMethod method;
            PsiTypeParameterList list;
            if (!(element instanceof PsiMethod) || (list = (method = (PsiMethod)element).getTypeParameterList()) == null) continue;
            PsiTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                PsiTypeParameter parameter = parameters[i];
                if (!this.myQualifiedName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        if (element == null) {
            return null;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element))) {
            if (!this.myQualifiedName.equals(parameter.getName())) continue;
            return parameter;
        }
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myQualifiedName, this.getResolveScope());
    }

    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public String getReferenceName() {
        return PsiNameHelper.getShortClassName((String)this.myCanonicalText);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = this.myTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[this.myTypeParameters.length];
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getTypeParameters must not return null");
        }
        return cachedTypes;
    }

    public boolean isQualified() {
        return false;
    }

    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        public JavaResolveResult[] resolve(ClsJavaCodeReferenceElementImpl ref, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult = ref.advancedResolveImpl();
            if (resolveResult.getElement() == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            return javaResolveResultArray;
        }
    }
}

