/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class ClsAnnotationsUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsAnnotationsUtil");

    private ClsAnnotationsUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue getMemberValue(PsiElement element, ClsElementImpl parent) {
        ClsElementImpl clsElementImpl;
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression expr = (PsiLiteralExpression)element;
            ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, element.getText(), expr.getType(), expr.getValue());
            clsElementImpl = clsLiteralExpressionImpl;
            if (clsLiteralExpressionImpl != null) return clsElementImpl;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
        }
        if (element instanceof PsiPrefixExpression) {
            PsiExpression operand = ((PsiPrefixExpression)element).getOperand();
            ClsLiteralExpressionImpl literal = (ClsLiteralExpressionImpl)ClsAnnotationsUtil.getMemberValue((PsiElement)operand, null);
            ClsPrefixExpressionImpl prefixExpression = new ClsPrefixExpressionImpl(parent, (PsiExpression)literal);
            literal.setParent(prefixExpression);
            ClsPrefixExpressionImpl clsPrefixExpressionImpl = prefixExpression;
            clsElementImpl = clsPrefixExpressionImpl;
            if (clsPrefixExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
            return clsElementImpl;
        }
        if (element instanceof PsiClassObjectAccessExpression) {
            PsiClassObjectAccessExpression expr = (PsiClassObjectAccessExpression)element;
            ClsClassObjectAccessExpressionImpl clsClassObjectAccessExpressionImpl = new ClsClassObjectAccessExpressionImpl(expr.getOperand().getType().getCanonicalText(), parent);
            clsElementImpl = clsClassObjectAccessExpressionImpl;
            if (clsClassObjectAccessExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
            return clsElementImpl;
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            int i = 0;
            while (true) {
                if (i >= initializers.length) {
                    ClsArrayInitializerMemberValueImpl clsArrayInitializerMemberValueImpl = arrayValue;
                    clsElementImpl = clsArrayInitializerMemberValueImpl;
                    if (clsArrayInitializerMemberValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
                    return clsElementImpl;
                }
                clsInitializers[i] = ClsAnnotationsUtil.getMemberValue((PsiElement)initializers[i], arrayValue);
                ++i;
            }
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            final String canonicalText = psiAnnotation.getNameReferenceElement().getCanonicalText();
            ClsAnnotationValueImpl clsAnnotationValueImpl = new ClsAnnotationValueImpl(parent){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)this.getParent();
                }
            };
            clsElementImpl = clsAnnotationValueImpl;
            if (clsAnnotationValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
            return clsElementImpl;
        }
        if (element instanceof PsiReferenceExpression) {
            ClsReferenceExpressionImpl clsReferenceExpressionImpl = new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)element);
            clsElementImpl = clsReferenceExpressionImpl;
            if (clsReferenceExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
            return clsElementImpl;
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        clsElementImpl = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.getMemberValue must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue createMemberValueFromText(String text, PsiManager manager, ClsElementImpl parent) {
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        PsiJavaFile dummyJavaFile = ((PsiElementFactoryImpl)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory()).getDummyJavaFile();
        FileElement holderElement = DummyHolderFactory.createHolder(manager, (PsiElement)dummyJavaFile).getTreeElement();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)parent);
        JavaParsingContext context = new JavaParsingContext(holderElement.getCharTable(), languageLevel);
        TreeElement element = context.getDeclarationParsing().parseMemberValueText(manager, text, languageLevel);
        if (element == null) {
            LOG.error("Could not parse initializer:'" + text + "'");
            psiAnnotationMemberValue = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.createMemberValueFromText must not return null");
        } else {
            holderElement.rawAddChildren(element);
            PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
            psiAnnotationMemberValue = ClsAnnotationsUtil.getMemberValue(psiElement, parent);
            if (psiAnnotationMemberValue == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationsUtil.createMemberValueFromText must not return null");
            return psiAnnotationMemberValue;
        }
    }
}

